% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.R
\name{annotate_mouse_genes}
\alias{annotate_mouse_genes}
\title{Annotate with genes}
\usage{
annotate_mouse_genes(geno, flanking = NULL)
}
\arguments{
\item{geno}{Data frame or GenomicRanges::GRanges object including columns
chr, pos.}

\item{flanking}{Size of flanking sequence to be included.}
}
\value{
Data frame.
}
\description{
Request mouse genes from Ensembl Biomart.
}
\examples{
geno = finemap("chr1",
  start = 5000000, end = 6000000,
  strain1 = c("C57BL_6J"), strain2 = c("AKR_J", "A_J", "BALB_cJ")
)

genes = annotate_mouse_genes(geno, 50000)
}
