% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Motif2Site.R
\name{DetectBindingSitesMotif}
\alias{DetectBindingSitesMotif}
\title{Detect binding sites from sequence motif sequence and mismatchNumber}
\usage{
DetectBindingSitesMotif(
  motif,
  mismatchNumber,
  IPfiles,
  BackgroundFiles,
  genome,
  genomeBuild,
  DB = "UCSC",
  fdrValue = 0.05,
  expName = "Motif_Centric_Peaks",
  windowSize = 100,
  format = "",
  GivenRegion = NA
)
}
\arguments{
\item{motif}{motif characters in nucleotide IUPAC format}

\item{mismatchNumber}{Number of mismatches allowed to match with motifs}

\item{IPfiles}{IP ChIP-seq alignment files}

\item{BackgroundFiles}{Background ChIP-seq alignment files. Can be Input
experimetn, DNA whole exctract, etc.}

\item{genome}{The genome name such as "Hsapiens", "Mmusculus",
"Dmelanogaster"}

\item{genomeBuild}{The genome build such as "hg38", "hg19", "mm10", "dm3"}

\item{DB}{The database of genome build. default: "UCSC"}

\item{fdrValue}{FDR value cut-off}

\item{expName}{The name of the output table}

\item{windowSize}{Window size around binding site. The total region would be
2*windowSize+1}

\item{format}{alignment format and should be one of these: "BAMPE", "BAMSE",
"BEDPE", "BEDSE"}

\item{GivenRegion}{granges of user provided binding regions}
}
\value{
A list FRiPs, sequence statistics, and Motif statistics
}
\description{
DETECT Binding sites with given motif and mismatch number as
well genome/build, False Discovery Rate for a given experiment name. Read bam
 or bed alignment files and convert to 1 nt bed and detect binding site among
  motifs from 1nt bed alignment.
}
\examples{

# ChIP-seq datasets in bed single end format
IPFe <- c(system.file("extdata", "FUR_fe1.bed", package="Motif2Site"),
        system.file("extdata", "FUR_fe2.bed", package="Motif2Site"))
Inputs <- c(system.file("extdata", "Input1.bed", package="Motif2Site"),
            system.file("extdata", "Input2.bed", package="Motif2Site"))

 # Granages region for motif search           
   NC_000913_Coordiante <-
     GenomicRanges::GRanges(seqnames=S4Vectors::Rle("NC_000913"),
                            ranges=IRanges::IRanges(1, 4639675))           
            
FURfeStringInputStats <- 
  DetectBindingSitesMotif(motif="GWWTGAGAA",
   mismatchNumber=1,
   IPfiles=IPFe, 
   BackgroundFiles=Inputs, 
   genome="Ecoli",
   genomeBuild="20080805",
   DB="NCBI",
   expName="FUR_Fe_StringInput",
   format="BEDSE",
   GivenRegion=NC_000913_Coordiante 
   )

                                      
}
\seealso{
\code{\link{DetectBindingSitesBed}}
}
