% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Motif2Site.R
\name{DetectBindingSites}
\alias{DetectBindingSites}
\title{Detect binding sites from motif}
\usage{
DetectBindingSites(
  From,
  BedFile,
  motif,
  mismatchNumber,
  chipSeq,
  genome,
  genomeBuild,
  DB = "UCSC",
  fdrValue = 0.05,
  windowSize = 100,
  GivenRegion = NA,
  currentDir
)
}
\arguments{
\item{From}{Type of motif dataset either "Motif" or "Bed"}

\item{BedFile}{Motif locations in bed format file}

\item{motif}{motif characters in nucleotide IUPAC format}

\item{mismatchNumber}{Number of mismatches allowed to match with motifs}

\item{chipSeq}{ChIP-seq alignment both IP and background in 1nt bed format
files}

\item{genome}{The genome name such as "Hsapiens", "Mmusculus",
"Dmelanogaster"}

\item{genomeBuild}{The genome build such as "hg38", "hg19", "mm10", "dm3"}

\item{DB}{The database of genome build. default: "UCSC"}

\item{fdrValue}{FDR value cut-off}

\item{windowSize}{Window size around binding site. The total region would be
2*windowSize+1}

\item{GivenRegion}{granges of user provided binding regions}

\item{currentDir}{Directory for I/O operations}
}
\value{
A list of FRiPs, sequence statistics, and Motif statistics
}
\description{
DETECT Binding sites with given motif and mismatch number as
 well genome/build, False Discovery Rate for a given experiment name.

This function is called by both
 \code{\link{DetectBindingSitesBed}} and
  \code{\link{DetectBindingSitesMotif}} with different input.
}
