% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/MoleculeExperiment.R
\docType{class}
\name{MoleculeExperiment-class}
\alias{MoleculeExperiment-class}
\alias{MoleculeExperiment}
\title{MoleculeExperiment class: An S4 class container to store imaging-based
spatial transcriptomics data.}
\usage{
MoleculeExperiment(molecules, boundaries = NULL)
}
\arguments{
\item{molecules}{Detected transcripts information in a standardised ME list
format, as is generated by dataframeToMEList() and readMolecules() functions.}

\item{boundaries}{Slot with boundary information in a standardised ME list
format, as is generated by dataframeToMEList() and readBoundaries()
functions.}
}
\value{
A MoleculeExperiment object
}
\description{
This class enables the analysis of imaging-based ST data at the molecule
level, and standardises data across vendors. The aim of this class is to
facilitate ST data integration and comparison and, importantly, facilitate
common analytical and visualisation workflows.
}
\section{Slots}{

\describe{
\item{\code{molecules}}{Slot containing information about the detected transcripts.
This slot is designed as a list of lists, where each sample contains a list
of tibbles with information for each gene. The basic information required
for this slot are the gene names of the transcripts, as well as their x and
y locations.}

\item{\code{boundaries}}{Slot containing the boundaries defining each segmented cell.
The slot is designed as a list of lists, where each sample contains a list
of tibbles for each cell, consisting of the x and y coordinates of the
polygon vertices defining the cell boundary.}
}}

\examples{
# creating a simple ME object from toy data
moleculesDf <- data.frame(
    sample_id = rep(c("sample1", "sample2"), times = c(30, 20)),
    features = rep(c("gene1", "gene2"), times = c(20, 30)),
    x_coords = runif(50),
    y_coords = runif(50)
)
boundariesDf <- data.frame(
    sample_id = rep(c("sample1", "sample2"), times = c(16, 6)),
    cell_id = rep(c("cell1", "cell2", "cell3", "cell4",
                    "cell1", "cell2"),
                  times = c(4, 4, 4, 4, 3, 3)),
    vertex_x = rnorm(22),
    vertex_y = rnorm(22)
)
moleculesMEList <- dataframeToMEList(moleculesDf,
                                  dfType = "molecules",
                                  assayName = "detected",
                                  sampleCol = "sample_id",
                                  factorCol = "features",
                                  xCol = "x_coords",
                                  yCol = "y_coords")

boundariesMEList <- dataframeToMEList(boundariesDf,
                                   dfType = "boundaries",
                                   assayName = "cell",
                                   sampleCol = "sample_id",
                                   factorCol = "cell_id",
                                   xCol = "vertex_x",
                                   yCol = "vertex_y")

toyME <- MoleculeExperiment(molecules = moleculesMEList,
                             boundaries = boundariesMEList)

toyME

}
