% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Modstrings-sanitize.R
\name{sanitizeInput}
\alias{sanitizeInput}
\alias{sanitizeFromModomics}
\alias{sanitizeFromtRNAdb}
\title{Sanitize input strings for use with ModString classes}
\usage{
sanitizeInput(input, dictionary)

sanitizeFromModomics(input)

sanitizeFromtRNAdb(input)
}
\arguments{
\item{input}{a \code{character} vector, which should be converted}

\item{dictionary}{a DataFrame containing at least two columns 
\code{mods_abbrev} and \code{short_name}. From this a dictionary table is
contructed for exchaning old to new letters.}
}
\value{
the modified \code{character} vector compatible for constructing a
\code{ModString} object.
}
\description{
Since the one letter nomenclature for RNA and DNA modification differs
depending on the source, a translation to a common alphabet is necessary.

\code{sanitizeInput} exchanges based on a dictionary. The dictionary is
expected to be a \code{DataFrame} with two columns, \code{mods_abbrev} and
\code{short_name}. Based on the \code{short_name} the characters from in the 
input are converted from values of \code{mods_abbrev} into the the ones
from \code{alphabet}.

Only different values will be searched for and exchanged.

\code{sanitizeFromModomics} and \code{sanitizeFromtRNAdb} use a predefined
dictionary, which is builtin.
}
\examples{
# Modomics
chr <- "AGC@"
# Error since the @ is not in the alphabet
\dontrun{
seq <- ModRNAString(chr)
}
seq <- ModRNAString(sanitizeFromModomics(chr))
seq

# tRNAdb
chr <- "AGC+"
# No error but the + has a different meaning in the alphabet
\dontrun{
seq <- ModRNAString(chr)
}
seq <- ModRNAString(sanitizeFromtRNAdb(chr))
seq
}
