% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Modstrings-QualityScaledModStringSet.R
\docType{class}
\name{QualityScaledModStringSet}
\alias{QualityScaledModStringSet}
\alias{show,QualityScaledModStringSet-method}
\alias{QualityScaledModDNAStringSet-class}
\alias{QualityScaledModRNAStringSet-class}
\alias{QualityScaledModDNAStringSet}
\alias{QualityScaledModRNAStringSet}
\alias{readQualityScaledModDNAStringSet}
\alias{readQualityScaledModRNAStringSet}
\alias{writeQualityScaledModStringSet}
\title{QualityScaledModDNAStringSet and QualityScaledModRNAStringSet objects}
\usage{
QualityScaledModDNAStringSet(x, quality)

QualityScaledModRNAStringSet(x, quality)

readQualityScaledModDNAStringSet(
  filepath,
  quality.scoring = c("phred", "solexa", "illumina"),
  nrec = -1L,
  skip = 0L,
  seek.first.rec = FALSE,
  use.names = TRUE
)

readQualityScaledModRNAStringSet(
  filepath,
  quality.scoring = c("phred", "solexa", "illumina"),
  nrec = -1L,
  skip = 0L,
  seek.first.rec = FALSE,
  use.names = TRUE
)

writeQualityScaledModStringSet(
  x,
  filepath,
  append = FALSE,
  compress = FALSE,
  compression_level = NA
)
}
\arguments{
\item{x}{For the \code{QualityScaled*StringSet} constructors: Either a 
character vector, or an \code{ModString}, \code{ModStringSet} or 
\code{ModStringViews} object.

For \code{writeQualityScaledXStringSet}: A 
\code{\link{QualityScaledModDNAStringSet}} or 
\code{\link{QualityScaledModRNAStringSet}} object.}

\item{quality}{A 
\code{\link[Biostrings:XStringQuality-class]{XStringQuality}} object.}

\item{filepath, nrec, skip, seek.first.rec, use.names, append, compress, compression_level}{See \code{\link[Biostrings:QualityScaledXStringSet-class]{QualityScaledXStringSet-class}}.}

\item{quality.scoring}{Specify the quality scoring used in the FASTQ file. 
Must be one of "phred" (the default), "solexa", or "illumina". If set to "
phred" (or "solexa" or "illumina"), the qualities will be stored in a 
\code{PhredQuality} (or \code{SolexaQuality} or \code{IlluminaQuality}, 
respectively) object.}
}
\value{
a \code{QualityScaledModDNAStringSet} or 
\code{QualityScaledModDNAStringSet} object
}
\description{
title
}
\examples{
seq <- ModRNAString("AGCU7")
seq

qseq <- PhredQuality(paste0(rep("!", length(seq)), collapse = ""))
qseq

qset <- QualityScaledModRNAStringSet(seq, qseq)
qset
}
