% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-grid.R
\name{pedigreeGrid}
\alias{pedigreeGrid}
\title{Plot the log R ratios and BAFs on a grid given by precomputed viewports}
\usage{
pedigreeGrid(g, vps, figs)
}
\arguments{
\item{g}{a \code{MDRanges} object}

\item{vps}{a list of viewports.  See \code{\link{pedigreeViewports}}.}

\item{figs}{a list of trellis objects created by the function \code{\link{plotDenovo}}.}
}
\description{
Plot the log R ratios and BAFs on a grid given by precomputed viewports
}
\examples{
library(VanillaICE)
require(grid)
##marker-level summaries
data(md_exp)
seqlevels(md_exp, pruning.mode="coarse") <- "chr22"
## segmentation results
data(md_gr)
posteriorCalls <- MAP2(md_exp, md_gr, MinDistParam())
g <- denovoHemizygous(posteriorCalls)
g
vps <- MinimumDistance:::pedigreeViewports()
param <- HmmTrellisParam()
p <- plotDenovo(md_exp, g[1], param)
p <- pedigreeGrid(g=g[1], vps=vps, figs=p)
leg <- mdLegend(g[1])
upViewport(0)
pushViewport(vps[["legend"]])
grid.text(leg, x=unit(0.02, "npc"), y=unit(0.95, "npc"), just=c("left", "top"),
          gp=gpar(cex=0.6, fontfamily="mono"))
##
## combine adjacent denovo hemizygous
##
g2 <- reduce(denovoHemizygous(posteriorCalls), min.gapwidth=500e3)
post <- MAP2(md_exp, g2)
g2 <- denovoHemizygous(post)
p <- plotDenovo(md_exp, g2, param)
p <- pedigreeGrid(g=g2, vps=vps, figs=p)
leg <- mdLegend(g2)
upViewport(0)
pushViewport(vps[["legend"]])
grid.text(leg, x=unit(0.02, "npc"), y=unit(0.95, "npc"), just=c("left", "top"),
          gp=gpar(cex=0.6, fontfamily="mono"))
}
\seealso{
\code{\link{plotDenovo}} \code{\link{pedigreeViewports}}
}
