% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defunct.R
\name{TrioSetListLD}
\alias{TrioSetListLD}
\title{Deprecated TrioSetList constructor for large data}
\usage{
TrioSetListLD(
  path,
  fnames,
  ext = "",
  samplesheet,
  row.names,
  pedigreeData,
  featureData,
  annotationPkg,
  outdir = ldPath(),
  ffprefix = "",
  genome = c("hg19", "hg18")
)
}
\arguments{
\item{path}{Path to plain-text files containing log R ratios and B
allele frequencies.  Files should contain data for a single sample.}

\item{fnames}{Character string providing filenames.}

\item{ext}{Character string indicating whether the \code{fnames}
has a file extension (e.g., ".txt")}

\item{samplesheet}{(Optional) \code{data.frame} containing
phenotypic / experimental covariates on the samples.  Note that if
\code{samplesheet} is provided, \code{row.names} must be specified.}

\item{row.names}{Character vector indicating the sample id for each
row in \code{samplesheet}.  \code{row.names} should be unique and,
ideally, correspond to \code{fnames}}

\item{pedigreeData}{An object of class \code{Pedigree}.}

\item{featureData}{A \code{GenomeAnnotatedDataFrame}}

\item{annotationPkg}{Character string indicating the annotation
package used to extract information on the features (chromosome,
physical position, and whether the feature is polymorphic
('isSnp')).}

\item{outdir}{Character string indicating the path for storing \code{ff}  objects.  Ignored if the \pkg{ff} package is not loaded.}

\item{ffprefix}{Character string indicating the prefix used to name
ff objects. Ignored if the \pkg{ff} package is not loaded.}

\item{genome}{character string indicating UCSC genome build. Only
"hg19" is allowed for annotation packages that support a single
build. Supported builds for most platforms are "hg18" and "hg19".}
}
\value{
A \code{TrioSetList} object
}
\description{
The TrioSetListLD constructor uses ff objects to handle large
datasets.  This function is defunct. Use MinDistExperiment instead.
}
\seealso{
\code{\linkS4class{TrioSetList}}
}
