% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{MAP}
\alias{MAP}
\title{Computes the maximum a posteriori trio copy number state for the
segmented minimum distance}
\usage{
MAP(
  object,
  ranges,
  id,
  TAUP = 1e+10,
  tauMAX = 1 - 5e-08,
  cnStates = c(-2, -0.4, 0, 0, 0.4, 1),
  pr.nonmendelian = 1.5e-06,
  mdThr = 0.9,
  ...
)
}
\arguments{
\item{object}{see \code{showMethods(MAP)}}

\item{ranges}{A \code{GRanges} object}

\item{id}{character string for sample identifier}

\item{TAUP}{scalar for transition probabilities}

\item{tauMAX}{the maximum probability that the current state is the same as the previous state}

\item{cnStates}{character vector for hidden Markov model state labels}

\item{pr.nonmendelian}{numeric:  the a priori probability of a non-Mendelian copy number alteration}

\item{mdThr}{a length-one numeric vector.  A minimum distance below this threshold in absolute value will not be evaluated for copy number alterations.}

\item{...}{Ignored.}
}
\description{
This functions is deprecated and will be defunct in a future
release.  The replacement function is MAP2.
}
