% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_diff_analysis.R
\name{mp_plot_diff_boxplot}
\alias{mp_plot_diff_boxplot}
\alias{mp_plot_diff_boxplot,MPSE-method}
\alias{mp_plot_diff_boxplot,MPSE}
\alias{mp_plot_diff_boxplot,tbl_mpse-method}
\alias{mp_plot_diff_boxplot,tbl_mpse}
\alias{mp_plot_diff_boxplot,grouped_df_mpse-method}
\alias{mp_plot_diff_boxplot,grouped_df_mpse}
\title{displaying the differential result contained abundance and LDA with 
boxplot (abundance) and error bar (LDA).}
\usage{
mp_plot_diff_boxplot(
  .data,
  .group,
  .size = 2,
  errorbar.xmin = NULL,
  errorbar.xmax = NULL,
  point.x = NULL,
  taxa.class = "all",
  group.abun = FALSE,
  removeUnknown = FALSE,
  ...
)

\S4method{mp_plot_diff_boxplot}{MPSE}(
  .data,
  .group,
  .size = 2,
  errorbar.xmin = NULL,
  errorbar.xmax = NULL,
  point.x = NULL,
  taxa.class = "all",
  group.abun = FALSE,
  removeUnknown = FALSE,
  ...
)

\S4method{mp_plot_diff_boxplot}{tbl_mpse}(
  .data,
  .group,
  .size = 2,
  errorbar.xmin = NULL,
  errorbar.xmax = NULL,
  point.x = NULL,
  taxa.class = "all",
  group.abun = FALSE,
  removeUnknown = FALSE,
  ...
)

\S4method{mp_plot_diff_boxplot}{grouped_df_mpse}(
  .data,
  .group,
  .size = 2,
  errorbar.xmin = NULL,
  errorbar.xmax = NULL,
  point.x = NULL,
  taxa.class = "all",
  group.abun = FALSE,
  removeUnknown = FALSE,
  ...
)
}
\arguments{
\item{.data}{MPSE or tbl_mpse after run mp_diff_analysis with 'action="add"'.}

\item{.group}{the column name for mapping the different color.}

\item{.size}{the column name for mapping the size of points or numeric, default is 2.}

\item{errorbar.xmin}{the column name for 'xmin' mapping of error barplot layer, default is NULL.}

\item{errorbar.xmax}{the column name for 'xmax' mapping of error barplot layer, default is NULL.}

\item{point.x}{the column name for 'x' mapping of point layer (right panel), default is NULL.}

\item{taxa.class}{the taxonomy class features will be displayed, default is 'all'.}

\item{group.abun}{logical whether plot the abundance in each group with bar plot,
default is FALSE.}

\item{removeUnknown}{logical whether mask the unknown taxonomy information but 
differential species, default is FALSE.}

\item{...}{additional params, see also the 'geom_boxplot', 'geom_errorbarh' and 'geom_point'.}
}
\description{
displaying the differential result contained abundance and LDA with 
boxplot (abundance) and error bar (LDA).
}
\examples{
data(mouse.time.mpse)
mouse.time.mpse \%<>\%
  mp_rrarefy()
mouse.time.mpse
mouse.time.mpse \%<>\%
  mp_diff_analysis(.abundance=RareAbundance,
                   .group=time,
                   first.test.alpha=0.01,
                   action="add")
library(ggplot2)
p1 <- mouse.time.mpse \%>\% 
        mp_plot_diff_boxplot(.group = time) \%>\%
        set_diff_boxplot_color(
          values = c("deepskyblue", "orange"),
          guide = guide_legend(title=NULL)
        )
p1
p2 <- mouse.time.mpse \%>\% 
        mp_plot_diff_boxplot(
          taxa.class = c(Genus, OTU),
          group.abun = TRUE, 
          removeUnknown = TRUE,
        ) \%>\%
        set_diff_boxplot_color(
          values = c("deepskyblue", "orange"),
          guide = guide_legend(title=NULL)
        )
p2 
}
