% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_diff_analysis.R
\name{mp_diff_analysis}
\alias{mp_diff_analysis}
\alias{mp_diff_analysis,MPSE-method}
\alias{mp_diff_analysis,MPSE}
\alias{mp_diff_analysis,tbl_mpse-method}
\alias{mp_diff_analysis,tbl_mpse}
\alias{mp_diff_analysis,grouped_df_mpse-method}
\alias{mp_diff_analysis,grouped_df_mpse}
\title{Differential expression analysis for MPSE or tbl_mpse object}
\usage{
mp_diff_analysis(
  .data,
  .abundance,
  .group,
  .sec.group = NULL,
  action = "add",
  tip.level = "OTU",
  force = FALSE,
  relative = TRUE,
  taxa.class = "all",
  first.test.method = "kruskal.test",
  first.test.alpha = 0.05,
  p.adjust = "fdr",
  filter.p = "fdr",
  strict = TRUE,
  fc.method = "generalizedFC",
  second.test.method = "wilcox.test",
  second.test.alpha = 0.05,
  cl.min = 5,
  cl.test = TRUE,
  subcl.min = 3,
  subcl.test = TRUE,
  ml.method = "lda",
  normalization = 1e+06,
  ldascore = 2,
  bootnums = 30,
  sample.prop.boot = 0.7,
  ci = 0.95,
  seed = 123,
  type = "species",
  ...
)

\S4method{mp_diff_analysis}{MPSE}(
  .data,
  .abundance,
  .group,
  .sec.group = NULL,
  action = "add",
  tip.level = "OTU",
  force = FALSE,
  relative = TRUE,
  taxa.class = "all",
  first.test.method = "kruskal.test",
  first.test.alpha = 0.05,
  p.adjust = "fdr",
  filter.p = "fdr",
  strict = TRUE,
  fc.method = "generalizedFC",
  second.test.method = "wilcox.test",
  second.test.alpha = 0.05,
  cl.min = 5,
  cl.test = TRUE,
  subcl.min = 3,
  subcl.test = TRUE,
  ml.method = "lda",
  normalization = 1e+06,
  ldascore = 2,
  bootnums = 30,
  sample.prop.boot = 0.7,
  ci = 0.95,
  seed = 123,
  type = "species",
  ...
)

\S4method{mp_diff_analysis}{tbl_mpse}(
  .data,
  .abundance,
  .group,
  .sec.group = NULL,
  action = "add",
  tip.level = "OTU",
  force = FALSE,
  relative = TRUE,
  taxa.class = "all",
  first.test.method = "kruskal.test",
  first.test.alpha = 0.05,
  p.adjust = "fdr",
  filter.p = "fdr",
  strict = TRUE,
  fc.method = "generalizedFC",
  second.test.method = "wilcox.test",
  second.test.alpha = 0.05,
  cl.min = 5,
  cl.test = TRUE,
  subcl.min = 3,
  subcl.test = TRUE,
  ml.method = "lda",
  normalization = 1e+06,
  ldascore = 2,
  bootnums = 30,
  sample.prop.boot = 0.7,
  ci = 0.95,
  seed = 123,
  type = "species",
  ...
)

\S4method{mp_diff_analysis}{grouped_df_mpse}(
  .data,
  .abundance,
  .group,
  .sec.group = NULL,
  action = "add",
  tip.level = "OTU",
  force = FALSE,
  relative = TRUE,
  taxa.class = "all",
  first.test.method = "kruskal.test",
  first.test.alpha = 0.05,
  p.adjust = "fdr",
  filter.p = "fdr",
  strict = TRUE,
  fc.method = "generalizedFC",
  second.test.method = "wilcox.test",
  second.test.alpha = 0.05,
  cl.min = 5,
  cl.test = TRUE,
  subcl.min = 3,
  subcl.test = TRUE,
  ml.method = "lda",
  normalization = 1e+06,
  ldascore = 2,
  bootnums = 30,
  sample.prop.boot = 0.7,
  ci = 0.95,
  seed = 123,
  type = "species",
  ...
)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object}

\item{.abundance}{the name of abundance to be calculated}

\item{.group}{the group name of the samples to be calculated.}

\item{.sec.group}{the second group name of the samples to be calculated.}

\item{action}{character, "add" joins the new information to the taxatree (if it exists) 
or \code{rowData} and return MPSE object,"only" return a 
non-redundant tibble with the result of different analysis. "get" return 'diffAnalysisClass' 
object.}

\item{tip.level}{character the taxa level to be as tip level}

\item{force}{logical whether to calculate the relative abundance forcibly when the abundance
is not be rarefied, default is FALSE.}

\item{relative}{logical whether calculate the relative abundance.}

\item{taxa.class}{character if taxa class is not 'all', only the specified taxa class will
be identified, default is 'all'.}

\item{first.test.method}{the method for first test, option is "kruskal.test", "oneway.test", 
"lm", "glm", or "glm.nb", "kruskal_test", "oneway_test" of "coin" package. default is "kruskal.test".}

\item{first.test.alpha}{numeric the alpha value for the first test, default is 0.05.}

\item{p.adjust}{character the correction method, default is "fdr", see also p.adjust function
default is fdr.}

\item{filter.p}{character the method to filter pvalue, default is fdr, meanings the features 
that fdr <= .first.test.alpha will be kept, if it is set to pvalue, meanings the features that
pvalue <= .first.test.alpha will be kept.}

\item{strict}{logical whether to performed in one-against-one when .sec.group is provided, 
default is TRUE (strict).}

\item{fc.method}{character the method to check which group has more abundance for the 
significantly different features, default is "generalizedFC", options are \code{generalizedFC}, 
\code{compare_median}, \code{compare_mean}.}

\item{second.test.method}{the method for one-against-one (the second test), default is "wilcox.test" 
other option is one of 'wilcox_test' of 'coin'; 'glm'; 'glm.nb' of 'MASS'.}

\item{second.test.alpha}{numeric the alpha value for the second test, default is 0.05.}

\item{cl.min}{integer the minimum number of samples per group for performing test, default is 5.}

\item{cl.test}{logical whether to perform test (second test) between the groups (the number of sample
of the .group should be also larger that cl.min), default is TRUE.}

\item{subcl.min}{integer the minimum number of samples in each second groups for performing test, 
default is 3.}

\item{subcl.test}{logical whether to perform test for between the second groups (the .sec.group 
should be provided and the number sample of each .sec.group should be larger than subcl.min, and 
strict is TRUE), default is TRUE.}

\item{ml.method}{the method for calculating the effect size of features, option is 'lda' or 'rf'.
default is 'lda'.}

\item{normalization}{integer set a big number if to get more meaningful values for the LDA score, 
or you can set NULL for no normalization, default is 1000000.}

\item{ldascore}{numeric the threshold on the absolute value of the logarithmic LDA score, default is 2.}

\item{bootnums}{integer, set the number of bootstrap iteration for lda or rf, default is 30.}

\item{sample.prop.boot}{numeric range from 0 to 1, the proportion of samples for calculating the effect
size of features, default is 0.7.}

\item{ci}{numeric, the confidence interval of effect size (LDA or MDA), default is 0.95.}

\item{seed}{a random seed to make the analysis reproducible, default is 123.}

\item{type}{character type="species" meaning the abundance matrix is from the species abundance, other 
option is "others", default is "species".}

\item{...}{additional parameters}
}
\value{
update object according to the action argument.
}
\description{
Differential expression analysis for MPSE or tbl_mpse object
}
\examples{
data(mouse.time.mpse)
mouse.time.mpse \%<>\%
  mp_rrarefy() 
mouse.time.mpse
mouse.time.mpse \%<>\%
  mp_diff_analysis(.abundance=RareAbundance, 
                   .group=time, 
                   first.test.alpha=0.01,
                   action="add") 
library(ggplot2)
p <- mouse.time.mpse \%>\% mp_plot_diff_res()
flag <- packageVersion("ggnewscale") >= "0.5.0"
# if flag is TRUE, you can also use p$ggnewscale to view the renamed scales.
new.fill <- ifelse(flag , "fill_ggnewscale_2", "fill_new")
p <- p + 
     scale_fill_manual(
       aesthetics = new.fill, # The fill aes was renamed to `new.fill` for the abundance dotplot layer
       values = c("skyblue", "orange")
     )  + 
     scale_fill_manual(
       values=c("skyblue", "orange") # The LDA barplot layer
     )
### and the fill aes for hight light layer of tree was renamed to `new.fill2`
### because the layer is the first layer used `fill`
new.fill2 <- ifelse(flag, "fill_ggnewscale_1", "fill_new_new")
p <- p + 
     scale_fill_manual(
       aesthetics = new.fill2,
       values = c("#E41A1C", "#377EB8", "#4DAF4A", 
                  "#984EA3", "#FF7F00", "#FFFF33", 
                  "#A65628", "#F781BF", "#999999")
     )
p
\dontrun{
  ### visualizing the differential taxa with cladogram
  f <- mouse.time.mpse \%>\% 
       mp_plot_diff_cladogram(
         label.size = 2.5, 
         hilight.alpha = .3, 
         bg.tree.size = .5, 
         bg.point.size = 2, 
         bg.point.stroke = .25
       ) + 
       scale_fill_diff_cladogram(
         values = c('skyblue', 'orange')
       ) +
       scale_size_continuous(range = c(1, 4))
  f
}
}
\author{
Shuangbin Xu
}
