% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-ggdiffbox.R
\name{ggdiffbox}
\alias{ggdiffbox}
\alias{ggdiffbox,diffAnalysisClass-method}
\alias{ggdiffbox,diffAnalysisClass}
\title{boxplot for the result of diff_analysis}
\usage{
ggdiffbox(obj, ...)

\S4method{ggdiffbox}{diffAnalysisClass}(
  obj,
  geom = "boxplot",
  box_notch = TRUE,
  box_width = 0.05,
  dodge_width = 0.6,
  addLDA = TRUE,
  factorLevels = NULL,
  featurelist = NULL,
  removeUnknown = TRUE,
  colorlist = NULL,
  l_xlabtext = NULL,
  ...
)
}
\arguments{
\item{obj}{object, diffAnalysisClass class.}

\item{..., }{additional arguments.}

\item{geom}{character, "boxplot" or "violin", default is "boxplot".}

\item{box_notch}{logical, see also `notch` of \code{\link[ggplot2]{geom_boxplot}},
default is TRUE.}

\item{box_width}{numeric, the width of boxplot, default is 0.05}

\item{dodge_width}{numeric, the width of dodge of boxplot, default is 0.6.}

\item{addLDA}{logical, whether add the plot to visulize the result of LDA, 
default is TRUE.}

\item{factorLevels}{list, the levels of the factors, default is NULL,
if you want to order the levels of factor, you can set this.}

\item{featurelist}{vector, the character vector, the sub feature of
originalD in diffAnalysisClass,default is NULL.}

\item{removeUnknown}{logical, whether remove the unknown taxonomy,
default is TRUE.}

\item{colorlist}{character, the color vector, default is NULL.}

\item{l_xlabtext}{character, the x axis text of left panel,
default is NULL.}
}
\value{
a 'ggplot' plot object, a box or violine plot for the result
of diffAnalysisClass.
}
\description{
boxplot for the result of diff_analysis
}
\examples{
\dontrun{
data(kostic2012crc)
kostic2012crc \%<>\% as.phyloseq()
head(phyloseq::sample_data(kostic2012crc),3)
kostic2012crc <- phyloseq::rarefy_even_depth(kostic2012crc,
                 rngseed=1024)
table(phyloseq::sample_data(kostic2012crc)$DIAGNOSIS)
set.seed(1024)
diffres <- diff_analysis(kostic2012crc, classgroup="DIAGNOSIS",
                         mlfun="lda", filtermod="fdr",
                         firstcomfun = "kruskal.test",
                         firstalpha=0.05, strictmod=TRUE,
                         secondcomfun = "wilcox.test",
                         subclmin=3, subclwilc=TRUE,
                         secondalpha=0.01, ldascore=3)
library(ggplot2)
p <- ggdiffbox(diffres, box_notch=FALSE, l_xlabtext="relative abundance")
# set factor levels
p2 <- ggdiffbox(diffres, box_notch=FALSE, l_xlabtext="relative abundance", 
                factorLevels=list(DIAGNOSIS=c("Tumor", "Healthy")))
}
}
\author{
Shuangbin Xu
}
