% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichKO.R
\name{gseKO}
\alias{gseKO}
\title{KO GSEA enrichment for microbiome data}
\usage{
gseKO(
  geneList,
  nPerm = 1000,
  exponent = 1,
  minGSSize = 10,
  maxGSSize = 500,
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  method = "multilevel",
  adaptive = FALSE,
  minPerm = 101,
  maxPerm = 1e+05,
  pvalThreshold = 0.1,
  verbose = TRUE
)
}
\arguments{
\item{geneList}{a vector of K gene id (e.g. K00001) or EC id (e.g. 1.1.1.27) with values.}

\item{nPerm}{number of permutations.}

\item{exponent}{exponent of weighting.}

\item{minGSSize}{minimal size of genes annotated by KEGG term for testing.}

\item{maxGSSize}{maximal size of genes annotated for testing.}

\item{pvalueCutoff}{pvalue cutoff on enrichment tests to report.}

\item{pAdjustMethod}{one of "holm","hochberg","hommel","bonferroni","BH",
"BY","fdr","none".}

\item{method}{one of "multilevel", "fgsea", "bioc".}

\item{adaptive}{whether to use adaptive permutation.}

\item{minPerm}{minimal number of permutations.}

\item{maxPerm}{maximal number of permutations.}

\item{pvalThreshold}{pvalue threshold for adaptive permutation.}

\item{verbose}{whether to show progress.}
}
\value{
A \code{gseaResult} instance.
}
\description{
KO GSEA enrichment for microbiome data
}
