% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_dnam_target_gene.R
\name{cor_dnam_target_gene}
\alias{cor_dnam_target_gene}
\title{Evaluate correlation of DNA methylation region and
target gene expression}
\usage{
cor_dnam_target_gene(
  pair.dnam.target,
  dnam,
  exp,
  filter.results = TRUE,
  min.cor.pval = 0.05,
  min.cor.estimate = 0,
  cores = 1
)
}
\arguments{
\item{pair.dnam.target}{A dataframe with the following columns:
regionID (DNA methylation) and target (target gene)}

\item{dnam}{DNA methylation matrix or SummarizedExperiment object
with regions/cpgs in rows and samples in columns are samples.
Samples should be in the same order as gene expression matrix (exp).}

\item{exp}{Gene expression matrix  or SummarizedExperiment object
(rows are genes, columns are samples) log2-normalized (log2(exp + 1)).
Samples should be in the same order as the DNA methylation matrix.}

\item{filter.results}{Filter results using min.cor.pval and min.cor.estimate thresholds}

\item{min.cor.pval}{P-value threshold filter (default: 0.05)}

\item{min.cor.estimate}{Correlation estimate threshold filter (default: not applied)}

\item{cores}{Number of CPU cores to be used. Default 1.}
}
\value{
A data frame with the following information: regionID, target gene,
correlation pvalue and estimate between
DNA methylation and target gene expression, FDR corrected p-values.
}
\description{
This function evaluate the correlation of the DNA methylation
and target gene expression using spearman rank correlation test.
Note that genes with RNA expression equal to 0 for all samples
will not be evaluated.
}
\examples{
dnam <- t(matrix(sort(c(runif(20))), ncol = 1))
rownames(dnam) <- c("chr3:203727581-203728580")
colnames(dnam) <- paste0("Samples",1:20)
exp <- dnam
rownames(exp) <- c("ENSG00000232886")
colnames(exp) <- paste0("Samples",1:20)

pair.dnam.target <- data.frame(
   "regionID" =  c("chr3:203727581-203728580"),
   "target" = "ENSG00000232886"
)

# Correlated DNAm and gene expression, display only significant associations
results.cor.pos <- cor_dnam_target_gene(
   pair.dnam.target = pair.dnam.target,
   dnam = dnam,
   exp = exp,
   filter.results = TRUE,
   min.cor.pval = 0.05,
   min.cor.estimate = 0.0
)
}
