% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_estimates.R
\name{plot_estimates}
\alias{plot_estimates}
\title{Visualization of parameter estimates from numeric fit of Bayesian model of dynamics}
\usage{
plot_estimates(
  data = NULL,
  estimates = metadata(data)[["estimates_dynamics"]],
  delta_t = TRUE,
  dynamics = TRUE,
  distance_conditions = TRUE
)
}
\arguments{
\item{data}{\link[SummarizedExperiment]{SummarizedExperiment} used to fit dynamics model and extract the estimates}

\item{estimates}{a list of data frames (elements: mu, sigma, lambda, euclidean_distance) that contains
the model estimates by estimates_dynamics() or if data is a \link[SummarizedExperiment]{SummarizedExperiment}  estimates
must be stored in metadata(data) under "estimates_dynamics"}

\item{delta_t}{should differences between time points be plotted?}

\item{dynamics}{should dynamics be plotted?}

\item{distance_conditions}{should differences in metabolite specific dynamic should be plotted?}
}
\value{
Visualization of differences between time points(delta_t) and dynamics
profiles of single metabolites
}
\description{
Visualization of parameter estimates from numeric fit of Bayesian model of dynamics
}
\examples{
data("longitudinalMetabolomics")
data <- longitudinalMetabolomics[, longitudinalMetabolomics$condition \%in\% c("A", "B") &
  longitudinalMetabolomics$metabolite \%in\% c("ATP")]
data <- fit_dynamics_model(
  data = data,
  scaled_measurement = "m_scaled", assay = "scaled_log",
  max_treedepth = 14, adapt_delta = 0.95, iter = 2000, cores = 1, chains = 1
)
data <- estimates_dynamics(
  data = data
)
plot_estimates(data = data, delta_t = TRUE, dynamic = FALSE, distance_conditions = FALSE)
plot_estimates(data = data, delta_t = FALSE, dynamic = TRUE, distance_conditions = FALSE)
plot_estimates(data = data, delta_t = FALSE, dynamic = FALSE, distance_conditions = TRUE)
}
\seealso{
parent function \code{\link[=estimates_dynamics]{estimates_dynamics()}}
}
