% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_PPC.R
\name{plot_PPC}
\alias{plot_PPC}
\title{Plots posterior predictive check of numerical fit of Bayesian dynamics model}
\usage{
plot_PPC(
  posterior = metadata(data)[["diagnostics_dynamics"]],
  data,
  assay = "scaled_log",
  scaled_measurement = "scaled_measurement"
)
}
\arguments{
\item{posterior}{a dataframe that
contains necessary information for Posterior predictive check
obtained by function diagnostics_dynamics()(named "PPC_condition")}

\item{data}{dataframe or colData of a \link[SummarizedExperiment]{SummarizedExperiment}  used to fit dynamics model}

\item{assay}{of the \link[SummarizedExperiment]{SummarizedExperiment}  object that was used to fit the dynamics
model}

\item{scaled_measurement}{column name of concentration values used to model fit, should be normalized by
experimental condition and metabolite to mean of zero and standard deviation
of one}
}
\value{
a list of visual posterior predictive check, one per experimental condition
}
\description{
Plots posterior predictive check of numerical fit of Bayesian dynamics model
}
\examples{
data("longitudinalMetabolomics")
data <- longitudinalMetabolomics[, longitudinalMetabolomics$condition == "A" &
  longitudinalMetabolomics$metabolite \%in\% c("ATP", "ADP")]
data <- fit_dynamics_model(
  model = "scaled_log",
  data = data,
  scaled_measurement = "m_scaled", assay = "scaled_log",
  max_treedepth = 14, adapt_delta = 0.95, iter = 2000, cores = 1, chains = 1
)
data <- diagnostics_dynamics(
  data = data, assay = "scaled_log",
  iter = 2000, chains = 1,
  fit = metadata(data)[["dynamic_fit"]]
)
plot_PPC(
  data = data, assay = "scaled_log"
)
}
\seealso{
parent function \code{\link[=diagnostics_dynamics]{diagnostics_dynamics()}}
visualization function for diagnostics \code{\link[=plot_diagnostics]{plot_diagnostics()}}
}
