% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap_metabolites.R
\name{heatmap_metabolites}
\alias{heatmap_metabolites}
\title{plot heatmap from comparison of metabolite composition compare_metabolites()}
\usage{
heatmap_metabolites(
  distances = metadata(data)[["comparison_metabolites"]],
  data
)
}
\arguments{
\item{distances}{dataframe of Jaccard indices between clusters obtained
by function compare_metabolites(). If compare_metabolites() was executed on
as SummarizedExperiment or a \link[SummarizedExperiment]{SummarizedExperiment} than this is stored in metadata(data) under "comparison_metabolites"}

\item{data}{a dataframe containing the columns "metabolite" specifying the
metabolite names to be compared and cluster IDs(column named "cluster") of
clusters of similar dynamics, as well as a column "condition" specifying
the experimental conditions
to be compared}
}
\value{
a heatmap where the color of the tile represents the similarity
of two clusters in regards to their metabolite composition. The brighter
the color the more similar the metabolite compositions.
}
\description{
plot heatmap from comparison of metabolite composition compare_metabolites()
}
\examples{
data("longitudinalMetabolomics")
longitudinalMetabolomics <- compare_metabolites(
  data = longitudinalMetabolomics
)
heatmap_metabolites(data = longitudinalMetabolomics)
}
\seealso{
Do calculations for comparison of metabolites between clusters \code{\link[=compare_metabolites]{compare_metabolites()}}
}
