% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_dynamics_model.R
\name{fit_dynamics_model}
\alias{fit_dynamics_model}
\title{Fits dynamics model}
\usage{
fit_dynamics_model(
  model = "scaled_log",
  data,
  scaled_measurement = "m_scaled",
  counts = NULL,
  assay = "scaled_log",
  chains = 4,
  cores = 4,
  adapt_delta = 0.95,
  max_treedepth = 10,
  iter = 2000,
  warmup = iter/4
)
}
\arguments{
\item{model}{which model to fit. Two options are available:
"scaled_log": taking in normalized and scaled metabolite concentrations (see scaled measurement)
"raw_plus_counts": tailored for in vitro untargeted LC-MS experiments, taking in "raw"
(i.e. not normalized and not scaled) metabolite concentrations and cell counts.
This model assumes independent measurement (i.e. different wells) of cell counts
and metabolite concentrations. Additionally it assumes that cell counts were estimated
e.g. by cell counters (i.e. that cells were not counted under the microscope)
leading to a small uncertainty of the true cell count.}

\item{data}{concentration table with at least three replicate measurements per
metabolite. Must contain columns named "metabolite" (containing names or IDs), "time" (categorical, the same for all conditions), and "condition" or colData of a \link[SummarizedExperiment]{SummarizedExperiment} object
Time column needs to be sorted in ascending order}

\item{scaled_measurement}{column of "data" that contains the concentrations per cell,
centered and normalized per metabolite and experimental condition (mean=0, sd=1),
must be numeric}

\item{counts}{data frame with at least one replicate per time point and condition
specifying the cell counts, must contain columns "time", and "condition" equivalent
to the specifications of "data".
Must contain a column named "counts" that specifies the cell counts.
Model assumes that the replicates of the cell counts and metabolite concentrations
are independent of each other (i.e. cell counts were measured in in different
wells than metabolite concentrations)}

\item{assay}{if input is a SummarizedExperiment specify the assay that should
be used for input, colData has to hold the columns, "condition" and "metabolite",
rowData the timepoint specifications, in case of the model "scaled_log"
assay needs to hold scaled log-transformed metabolite concentrations
(mean=0,sd=1 per metabolite and experimental condition), if model
"raw_plus_counts" is chosen must hold the non-transformed and non-scaled metabolite concentrations}

\item{chains}{how many Markov-Chains should be used for model fitting, use at
least two, default=4}

\item{cores}{how many cores should be used for model fitting; this
parallelizes the model fitting and therefore speeds it up; default=4}

\item{adapt_delta}{target average acceptance probability, can be adapted if
divergent transitions are reported, default is 0.95}

\item{max_treedepth}{can be adapted if model throws warnings about hitting
max_treedepth, warnings are mostly efficiency not validity concerns and
treedepth can be raised, default=10}

\item{iter}{how many iterations are run, increasing might help with effective
sample size being to low, default=2000}

\item{warmup}{how many iterations the model warms up for, increasing might
facilitate efficiency, must be at least 25\% of ITER, default=iter/4}
}
\value{
returns a list of model fits. One model fit named "condition" per
experimental condition. If input is a summarizedExperiment object the dynamic
fits are stored metadata(data) under "dynamic_fits"
}
\description{
Employs a hierarchical model that assumes a normal distribution of
standardized (mean=0, sd=1) log(cpc) (cpc = normalized metabolite abundance)
values for robust estimation of mean
concentrations over time of single metabolites at single experimental
conditions.
At least three replicates for metabolite concentrations per time point and condition are needed.
If cell counts are provided at least one replicate per time point and condition is needed.
}
\examples{
## on scaled log-transformed metabolite concentrations
data("longitudinalMetabolomics")
data <- longitudinalMetabolomics[, longitudinalMetabolomics$condition \%in\% c("A", "B") &
  longitudinalMetabolomics$metabolite == "ATP"]
data <- fit_dynamics_model(
  model = "scaled_log",
  data = data,
  assay = "scaled_log",
  max_treedepth = 14, adapt_delta = 0.95, iter = 2000, cores = 1, chains = 1
)
S4Vectors::metadata(data)[["dynamic_fit"]]

}
\seealso{
Example data set\link{longitudinalMetabolomics}.
Get model diagnostics \code{\link[=diagnostics_dynamics]{diagnostics_dynamics()}}
Get model estimates \code{\link[=estimates_dynamics]{estimates_dynamics()}}
}
