% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical.R
\name{addToList}
\alias{addToList}
\title{Add adjacency matrix to list}
\usage{
addToList(l, name, object)
}
\arguments{
\item{l}{`list` of adjacency matrices}

\item{name}{`character`, name of added entry}

\item{object}{`matrix` that will be added}
}
\value{
`list` containing the existing matrices and the added matrix
}
\description{
This helper function used in the function
`statistical` adds an adjacency matrix to a `list` of
adjacency matrices.
}
\details{
The function `addToList` is a helper function used internally in
`statistical`.
}
\examples{
data("x_test", package = "MetNet")
x <- x_test[1:10, 3:ncol(x_test)]
x <- as.matrix(x)
cor_pearson <- correlation(x, method = "pearson")
cor_spearman <- correlation(x, method = "spearman")
l <- list(pearson = cor_pearson)
MetNet:::addToList(l, "spearman_coef", cor_spearman$r)
}
\author{
Thomas Naake, \email{thomasnaake@googlemail.com}
}
