% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/annotation_source_class.R
\name{required_cols}
\alias{required_cols}
\alias{required_cols,annotation_source-method}
\title{Required columns in an annotation source}
\usage{
required_cols(obj, ...)

\S4method{required_cols}{annotation_source}(obj)
}
\arguments{
\item{obj}{an \code{annotation_source} object}

\item{...}{additional source specific inputs}
}
\value{
a character vector of slot names
}
\description{
Some \code{annotation_sources}, such as LCMS tables (\code{lcms_table}), require that
certain columns are present in the data.frame. These are defined by slots in
the source definition. The name of slots containing the required column names
for a source can be retrieved using the \code{required_cols} function, which will
collect and return the names of slots containing required column names for
the object and all of its parent objects.
}
\examples{
# prepare object
M <- lcms_table(id_column = "id", mz_column = "mz", rt_column = "rt")

#' # get values for required slots
r <- required_cols(M)

# get slot names for required columns
names(r)
}
