% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_feature_selection.R
\name{MSstatsSelectFeatures}
\alias{MSstatsSelectFeatures}
\title{Feature selection before feature-level data summarization}
\usage{
MSstatsSelectFeatures(input, method, top_n = 3, min_feature_count = 2)
}
\arguments{
\item{input}{data.table}

\item{method}{"all" / "highQuality", "topN"}

\item{top_n}{number of features to use for "topN" method}

\item{min_feature_count}{number of quality features for "highQuality" method}
}
\value{
data.table
}
\description{
Feature selection before feature-level data summarization
}
\examples{
raw = DDARawData 
method = "TMP"
cens = "NA"
impute = TRUE
MSstatsConvert::MSstatsLogsSettings(FALSE)
input = MSstatsPrepareForDataProcess(raw, 2, NULL)
input = MSstatsNormalize(input, "EQUALIZEMEDIANS")
input = MSstatsMergeFractions(input)
input = MSstatsHandleMissing(input, "TMP", TRUE, "NA", 0.999)
input_all = MSstatsSelectFeatures(input, "all") # all features
input_5 = MSstatsSelectFeatures(data.table::copy(input), "topN", top_n = 5) # top 5 features
input_informative = MSstatsSelectFeatures(input, "highQuality") # feature selection

head(input_all)
head(input_5)
head(input_informative)

}
