% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantification.R
\name{quantification}
\alias{quantification}
\title{Protein sample quantification or group quantification}
\usage{
quantification(
  data,
  type = "Sample",
  format = "matrix",
  use_log_file = TRUE,
  append = FALSE,
  verbose = TRUE,
  log_file_path = NULL
)
}
\arguments{
\item{data}{name of the (processed) data set.}

\item{type}{choice of quantification. "Sample" or "Group" for protein sample
quantification or group quantification.}

\item{format}{choice of returned format. "long" for long format which has
the columns named Protein, Condition, LogIntensities (and BioReplicate if it is
subject quantification), NumFeature for number of transitions for a protein,
and NumPeaks for number of observed peak intensities for a protein.
"matrix" for data matrix format which has the rows for Protein and the columns,
which are Groups(or Conditions) for group quantification or the combinations
of BioReplicate and Condition (labeled by "BioReplicate"_"Condition")
for sample quantification. Default is "matrix"}

\item{use_log_file}{logical. If TRUE, information about data processing
will be saved to a file.}

\item{append}{logical. If TRUE, information about data processing will be added
to an existing log file.}

\item{verbose}{logical. If TRUE, information about data processing wil be printed
to the console.}

\item{log_file_path}{character. Path to a file to which information about 
data processing will be saved. 
If not provided, such a file will be created automatically.
If `append = TRUE`, has to be a valid path to a file.}
}
\value{
data.frame as described in details.
}
\description{
Model-based quantification for each condition or for each biological
sample per protein in a targeted Selected Reaction Monitoring (SRM),
Data-Dependent Acquisition (DDA or shotgun), and Data-Independent Acquisition
(DIA or SWATH-MS) experiment. Quantification takes the processed data set
by \code{\link{dataProcess}} as input and automatically generate the quantification
results (data.frame) in a long or matrix format.
}
\details{
\itemize{
\item{Sample quantification : individual biological sample quantification for each protein. The label of each biological sample is a combination of the corresponding group and the sample ID. If there are no technical replicates or experimental replicates per sample, sample quantification is the same as run summarization from dataProcess. If there are technical replicates or experimental replicates, sample quantification is median among run quantification corresponding MS runs.}
\item{Group quantification : quantification for individual group or individual condition per protein. It is median among sample quantification.}
\item{The quantification for endogenous samples is based on run summarization from subplot model, with TMP robust estimation.}
}
}
\examples{
# Consider quantitative data (i.e. QuantData) from a yeast study with ten time points of
# interests, three biological replicates, and no technical replicates which is
# a time-course experiment.
# Sample quantification shows model-based estimation of protein abundance in each biological
# replicate within each time point.
# Group quantification shows model-based estimation of protein abundance in each time point.
QuantData<-dataProcess(SRMRawData, use_log_file = FALSE)
head(QuantData$FeatureLevelData)
# Sample quantification
sampleQuant<-quantification(QuantData, use_log_file = FALSE)
head(sampleQuant)
# Group quantification
groupQuant<-quantification(QuantData, type="Group", use_log_file = FALSE)
head(groupQuant)

}
