% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converters.R
\name{MetamorpheusToMSstatsPTMFormat}
\alias{MetamorpheusToMSstatsPTMFormat}
\title{Import Metamorpheus files into PTM format}
\usage{
MetamorpheusToMSstatsPTMFormat(
  input,
  annotation,
  fasta_path,
  input_protein = NULL,
  annotation_protein = NULL,
  use_unmod_peptides = FALSE,
  mod_ids = c("\\\\[Common Biological:Phosphorylation on S\\\\]"),
  useUniquePeptide = TRUE,
  removeFewMeasurements = TRUE,
  removeProtein_with1Feature = FALSE,
  summaryforMultipleRows = max,
  use_log_file = TRUE,
  append = FALSE,
  verbose = TRUE,
  log_file_path = NULL
)
}
\arguments{
\item{input}{name of Metamorpheus output file, which is tabular format. Use the AllQuantifiedPeaks.tsv file from the Metamorpheus output.}

\item{annotation}{name of 'annotation.txt' data which includes Condition, BioReplicate.}

\item{fasta_path}{string containing path to the corresponding fasta file for
the modified peptide dataset.}

\item{input_protein}{same as \code{input} for global profiling run. Default is NULL.}

\item{annotation_protein}{same as \code{annotation} for global profiling run. Default is NULL.}

\item{use_unmod_peptides}{If \code{protein_input} is not provided,
unmodified peptides can be extracted from \code{input} to be used in place of a
global profiling run. Default is \code{FALSE}.}

\item{mod_ids}{List of modifications of interest. Default
is a list with only \verb{Common Biological:Phosphorylation on S}.
Please note that the 'mod_ids' parameter currently supports lists of size 1 only.
Future updates aim to extend its functionality to accommodate lists of greater sizes.
Note \verb{\\\\} must be included before special characters.}

\item{useUniquePeptide}{TRUE (default) removes peptides that are assigned for
more than one proteins. We assume to use unique peptide for each protein.}

\item{removeFewMeasurements}{TRUE (default) will remove the features that
have 1 or 2 measurements across runs.}

\item{removeProtein_with1Feature}{TRUE will remove the proteins which have
only 1 feature, which is the combination of peptide, precursor charge,
fragment and charge. FALSE is default.}

\item{summaryforMultipleRows}{max(default) or sum - when there are multiple
measurements for certain feature and certain run, use highest or sum of
multiple intensities.}

\item{use_log_file}{logical. If TRUE, information about data processing will
be saved to a file.}

\item{append}{logical. If TRUE, information about data processing will be
added to an existing log file.}

\item{verbose}{logical. If TRUE, information about data processing wil be
printed to the console.}

\item{log_file_path}{character. Path to a file to which information about
data processing will be saved. If not provided, such a file will be created
automatically. If 'append = TRUE', has to be a valid path to a file.}
}
\value{
a list of two data.tables named 'PTM' and 'PROTEIN' in the format
required by MSstatsPTM.
}
\description{
Import Metamorpheus files into PTM format
}
\examples{
input = system.file("tinytest/raw_data/Metamorpheus/AllQuantifiedPeaks.tsv", 
                                package = "MSstatsPTM")
input = data.table::fread(input)
annot = system.file("tinytest/raw_data/Metamorpheus/ExperimentalDesign.tsv", 
                                package = "MSstatsPTM")
annot = data.table::fread(annot)
input_protein = system.file("tinytest/raw_data/Metamorpheus/AllQuantifiedPeaksGlobalProteome.tsv",
                                package = "MSstatsPTM")
input_protein = data.table::fread(input_protein)
annot_protein = system.file("tinytest/raw_data/Metamorpheus/ExperimentalDesignGlobalProteome.tsv", 
                                package = "MSstatsPTM")
annot_protein = data.table::fread(annot_protein)
fasta_path=system.file("extdata", "metamorpheus_fasta.fasta", 
                                package="MSstatsPTM")
metamorpheus_imported = MetamorpheusToMSstatsPTMFormat(
    input, 
    annot, 
    fasta_path=fasta_path,
    input_protein=input_protein,
    annotation_protein=annot_protein,
    use_unmod_peptides=FALSE,
    mod_ids = c("\\\\[Common Fixed:Carbamidomethyl on C\\\\]")
)
head(metamorpheus_imported$PTM)
head(metamorpheus_imported$PROTEIN)
}
\author{
Anthony Wu
}
