% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{npcv}
\alias{npcv}
\title{Non-parametric coefficient of variation}
\usage{
npcv(x, na.rm = TRUE)
}
\arguments{
\item{x}{A \code{numeric}.}

\item{na.rm}{A \code{logical} (default is \code{TRUE} indicating
whether \code{NA} values should be stripped before the computation
of the median absolute deviation and mean.}
}
\value{
A \code{numeric}.
}
\description{
Calculates a non-parametric version of the coefficient of
variation where the standard deviation is replaced by the median
absolute deviations (see \code{\link{mad}} for details) and
divided by the absolute value of the mean.

Note that the \code{mad} of a single value is 0 (as opposed to
\code{NA} for the standard deviation, see example below).
}
\examples{
set.seed(1)
npcv(rnorm(10))
replicate(10, npcv(rnorm(10)))
npcv(1)
mad(1)
sd(1)
}
\author{
Laurent Gatto
}
