% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputation.R
\name{impute,MSnSet-method}
\alias{impute,MSnSet-method}
\alias{naset}
\title{Quantitative proteomics data imputation}
\usage{
\S4method{impute}{MSnSet}(object, method, ...)
}
\arguments{
\item{object}{An \code{MSnSet} object with missing values to be
imputed.}

\item{method}{\code{character(1)} defining the imputation method. See
\code{MsCoreUtils::imputeMethods()} for available ones. See
\code{\link[MsCoreUtils:imputation]{MsCoreUtils::impute_matrix()}} for details.}

\item{...}{Additional parameters passed to the inner imputation
function. See \code{\link[MsCoreUtils:imputation]{MsCoreUtils::impute_matrix()}} for details.}
}
\description{
The \code{impute} method performs data imputation on \code{MSnSet} instances
using a variety of methods.

Users should proceed with care when imputing data and take
precautions to assure that the imputation produce valid results,
in particular with naive imputations such as replacing missing
values with 0.

See \code{\link[MsCoreUtils:imputation]{MsCoreUtils::impute_matrix()}} for details on the different
imputation methods available and strategies.
}
\examples{

data(naset)

## table of missing values along the rows
table(fData(naset)$nNA)

## table of missing values along the columns
pData(naset)$nNA

## non-random missing values
notna <- which(!fData(naset)$randna)
length(notna)
notna

impute(naset, method = "min")

if (require("imputeLCMD")) {
    impute(naset, method = "QRILC")
    impute(naset, method = "MinDet")
}

if (require("norm"))
    impute(naset, method = "MLE")

impute(naset, "mixed",
       randna = fData(naset)$randna,
       mar = "knn", mnar = "QRILC")


## neighbour averaging
x <- naset[1:4, 1:6]

exprs(x)[1, 1] <- NA ## min value
exprs(x)[2, 3] <- NA ## average
exprs(x)[3, 1:2] <- NA ## min value and average
## 4th row: no imputation
exprs(x)

exprs(impute(x, "nbavg"))
}
