% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-MChromatograms.R,
%   R/methods-MChromatograms.R
\name{MChromatograms}
\alias{MChromatograms}
\alias{MChromatograms-class}
\alias{coerce,matrix,MChromatograms-method}
\alias{show,MChromatograms-method}
\alias{[,MChromatograms,ANY,ANY,ANY-method}
\alias{[<-,MChromatograms,ANY,ANY,ANY-method}
\alias{plot,MChromatograms,ANY-method}
\alias{phenoData,MChromatograms-method}
\alias{pData,MChromatograms-method}
\alias{pData<-,MChromatograms,data.frame-method}
\alias{$,MChromatograms-method}
\alias{$<-,MChromatograms-method}
\alias{colnames<-,MChromatograms,ANY-method}
\alias{sampleNames,MChromatograms-method}
\alias{sampleNames<-,MChromatograms,ANY-method}
\alias{isEmpty,MChromatograms-method}
\alias{featureNames,MChromatograms-method}
\alias{featureNames<-,MChromatograms-method}
\alias{featureData,MChromatograms-method}
\alias{featureData<-,MChromatograms,ANY-method}
\alias{fData,MChromatograms-method}
\alias{fData<-,MChromatograms,ANY-method}
\alias{fvarLabels,MChromatograms-method}
\alias{rownames<-,MChromatograms-method}
\alias{precursorMz,MChromatograms-method}
\alias{productMz,MChromatograms-method}
\alias{mz,MChromatograms-method}
\alias{polarity,MChromatograms-method}
\alias{bin,MChromatograms-method}
\alias{clean,MChromatograms-method}
\alias{normalize,MChromatograms-method}
\alias{filterIntensity,MChromatograms-method}
\alias{alignRt,MChromatograms,Chromatogram-method}
\alias{c,MChromatograms-method}
\alias{compareChromatograms,MChromatograms,missing-method}
\alias{compareChromatograms,MChromatograms,MChromatograms-method}
\alias{transformIntensity,MChromatograms-method}
\title{Container for multiple Chromatogram objects}
\usage{
MChromatograms(data, phenoData, featureData, ...)

\S4method{show}{MChromatograms}(object)

\S4method{[}{MChromatograms,ANY,ANY,ANY}(x, i, j, drop = FALSE)

\S4method{[}{MChromatograms,ANY,ANY,ANY}(x, i, j) <- value

\S4method{plot}{MChromatograms,ANY}(
  x,
  col = "#00000060",
  lty = 1,
  type = "l",
  xlab = "retention time",
  ylab = "intensity",
  main = NULL,
  ...
)

\S4method{phenoData}{MChromatograms}(object)

\S4method{pData}{MChromatograms}(object)

\S4method{pData}{MChromatograms,data.frame}(object) <- value

\S4method{$}{MChromatograms}(x, name)

\S4method{$}{MChromatograms}(x, name) <- value

\S4method{colnames}{MChromatograms,ANY}(x) <- value

\S4method{sampleNames}{MChromatograms}(object)

\S4method{sampleNames}{MChromatograms,ANY}(object) <- value

\S4method{isEmpty}{MChromatograms}(x)

\S4method{featureNames}{MChromatograms}(object)

\S4method{featureNames}{MChromatograms}(object) <- value

\S4method{featureData}{MChromatograms}(object)

\S4method{featureData}{MChromatograms,ANY}(object) <- value

\S4method{fData}{MChromatograms}(object)

\S4method{fData}{MChromatograms,ANY}(object) <- value

\S4method{fvarLabels}{MChromatograms}(object)

\S4method{rownames}{MChromatograms}(x) <- value

\S4method{precursorMz}{MChromatograms}(object)

\S4method{productMz}{MChromatograms}(object)

\S4method{mz}{MChromatograms}(object)

\S4method{polarity}{MChromatograms}(object)

\S4method{bin}{MChromatograms}(x, binSize = 0.5, breaks = numeric(), fun = max)

\S4method{clean}{MChromatograms}(object, all = FALSE, na.rm = FALSE)

\S4method{normalize}{MChromatograms}(object, method = c("max", "sum"))

\S4method{filterIntensity}{MChromatograms}(object, intensity = 0, ...)

\S4method{alignRt}{MChromatograms,Chromatogram}(x, y, method = c("closest", "approx"), ...)

\S4method{c}{MChromatograms}(x, ...)

\S4method{compareChromatograms}{MChromatograms,missing}(
  x,
  y,
  ALIGNFUN = alignRt,
  ALIGNFUNARGS = list(),
  FUN = cor,
  FUNARGS = list(use = "pairwise.complete.obs"),
  ...
)

\S4method{compareChromatograms}{MChromatograms,MChromatograms}(
  x,
  y,
  ALIGNFUN = alignRt,
  ALIGNFUNARGS = list(),
  FUN = cor,
  FUNARGS = list(use = "pairwise.complete.obs"),
  ...
)

\S4method{transformIntensity}{MChromatograms}(object, FUN = identity)
}
\arguments{
\item{data}{for \code{MChromatograms}: a \code{list} of \code{\link[=Chromatogram]{Chromatogram()}} objects.}

\item{phenoData}{for \code{MChromatograms}: either a \code{data.frame},
\code{AnnotatedDataFrame} describing the phenotypical information of the
samples.}

\item{featureData}{for \code{MChromatograms}: either a \code{data.frame} or
\code{AnnotatedDataFrame} with additional information for each row of
chromatograms.}

\item{...}{for \code{MChromatograms}: additional parameters to be passed to the
\code{matrix} constructor, such as \code{nrow}, \code{ncol} and \code{byrow}.
For \code{compareChromatograms}: ignored.}

\item{object}{a \code{MChromatograms} object.}

\item{x}{for all methods: a \code{MChromatograms} object.}

\item{i}{for \code{[}: \code{numeric}, \code{logical} or \code{character}
defining which row(s) to extract.}

\item{j}{for \code{[}: \code{numeric}, \code{logical} or \code{character}
defining which columns(s) to extract.}

\item{drop}{for \code{[}: \code{logical(1)} whether to drop the dimensionality of the
returned object (if possible). The default is \code{drop = FALSE}, i.e. each
subsetting returns a \code{MChromatograms} object (or a \code{Chromatogram} object
if a single element is extracted).}

\item{value}{for \verb{[<-}: the replacement object(s). Can be a \code{list}
of [Chromatogram()\verb{objects or, if length of}i\code{and}j\verb{are 1, a single}Chromatogram` object.

\if{html}{\out{<div class="sourceCode">}}\preformatted{For `pData<-`: a `data.frame` with the number of rows matching
the number of columns of `object`.

For `colnames`: a `character` with the new column names.
}\if{html}{\out{</div>}}}

\item{col}{for \code{plot}: the color to be used for plotting. Either a
vector of length 1 or equal to \code{ncol(x)}.}

\item{lty}{for \code{plot}: the line type (see \code{plot} in the \code{graphics} package
for more details). Can be either a vector of length 1 or of length equal
to \code{ncol(x)}.}

\item{type}{for \code{plot}: the type of plot (see \code{plot} from the \code{graphics}
package for more details). Can be either a vector of length 1 or of
length equal to \code{ncol(x)}.}

\item{xlab}{for \code{plot}: the x-axis label.}

\item{ylab}{for \code{plot}: the y-axis label.}

\item{main}{for \code{plot}: the plot title. If not provided the mz range
will be used as plot title.}

\item{name}{for \code{$}, the name of the pheno data column.}

\item{binSize}{for \code{bin}: \code{numeric(1)} with the size of the bins
(in seconds).}

\item{breaks}{For \code{bin}: \code{numeric} defining the bins. Usually not
required as the function calculates the bins automatically based on
\code{binSize} and the retention time range of chromatograms in the same
row.}

\item{fun}{for \code{bin}: function to be used to aggregate the intensity
values falling within each bin.}

\item{all}{for \code{clean}: \code{logical(1)} whether all 0-intensities
should be removed (\code{all = TRUE}), or whether 0-intensities
adjacent to peaks should be kept (\code{all = FALSE}; default).}

\item{na.rm}{for \code{clean}: \code{logical(1)} whether all \code{NA}
intensities should be removed prior to clean 0-intensity data points.}

\item{method}{\code{character(1)}. For \code{normalise}: defining whether each
chromatogram should be normalized to its maximum signal
(\code{method = "max"}) or total signal (\code{method = "sum"}).
For \code{alignRt}: alignment methods (see documentation for \code{alignRt} in the
\code{\link[=Chromatogram]{Chromatogram()}} help page. Defaults to \code{method = "closest"}.}

\item{intensity}{for \code{filterIntensity}: \code{numeric(1)} or \code{function} to use to
filter intensities. See description for details.}

\item{y}{for \code{alignRt}: a \code{\link[=Chromatogram]{Chromatogram()}} object against which \code{x} should be
aligned against.}

\item{ALIGNFUN}{for \code{compareChromatograms}: function to align chromatogram
\code{x} against chromatogram \code{y}. Defaults to \code{alignRt}.}

\item{ALIGNFUNARGS}{\code{list} of parameters to be passed to \code{ALIGNFUN}.}

\item{FUN}{for \code{transformIntensity}: function to transform chromatograms'
intensity values. Defaults to \code{FUN = identity}.}

\item{FUNARGS}{for \code{compareChromatograms}: \code{list} with additional parameters
for \code{FUN}. Defaults to \code{FUNARGS = list(use = "pairwise.complete.obs")}.}
}
\value{
For \code{[}: the subset of the \code{MChromatograms} object. If a
single element is extracted (e.g. if \code{i} and \code{j} are of length
1) a \code{\link[=Chromatogram]{Chromatogram()}} object is returned. Otherwise (if
\code{drop = FALSE}, the default, is specified) a \code{MChromatograms}
object is returned. If \code{drop = TRUE} is specified, the method
returns a \code{list} of \code{Chromatogram} objects.

\if{html}{\out{<div class="sourceCode">}}\preformatted{For `phenoData`: an `AnnotatedDataFrame` representing the
pheno data of the object.

For `pData`: a `data.frame` representing the pheno data of
the object.

For `$`: the value of the corresponding column in the pheno data
table of the object.

For all other methods see function description.
}\if{html}{\out{</div>}}
}
\description{
The \code{MChromatograms} class allows to store
\code{\link[=Chromatogram]{Chromatogram()}} objects in a \code{matrix}-like
two-dimensional structure.
}
\details{
The \code{MChromatograms} class extends the base \code{matrix} class
and hence allows to store \code{\link[=Chromatogram]{Chromatogram()}} objects in a
two-dimensional array. Each row is supposed to contain
\code{Chromatogram} objects for one MS data \emph{slice} with a common
m/z and rt range. Columns contain \code{Chromatogram} objects from the
same sample.
}
\section{Object creation}{


\code{MChromatograms} are returned by a \code{\link[=chromatogram]{chromatogram()}} function from an \code{MSnExp}
or \code{OnDiskMSnExp}. Alternatively, the \code{MChromatograms} constructor function
can be used.
}

\section{Data access}{

\itemize{
\item \code{$} and \verb{$<-}: get or replace individual columns of the object's phenodata.
\item \code{colnames} and \verb{colnames<-}: replace or set the column names of the
\code{MChromatograms} object. Does also set the \code{rownames} of the \code{phenoData}.
\item \code{fData}: return the feature data as a \code{data.frame}.
\item \verb{fData<-}: replace the object's feature data by passing a \code{data.frame}.
\item \code{featureData}: return the feature data.
\item \verb{featureData<-}: replace the object's feature data.
\item \code{featureNames}: returns the feature names of the \code{MChromatograms} object.
\item \verb{featureNames<-}: set the feature names.
\item \code{fvarLabels}: return the feature data variable names (i.e. column names).
\item \code{isEmpty}: returns \code{TRUE} if the \code{MChromatograms} object or all of its
\code{Chromatogram} objects is/are empty or contain only \code{NA} intensities.
\item \code{mz}: returns the m/z for each row of the \code{MChromatograms} object
as a two-column \code{matrix} (with columns \code{"mzmin"} and \code{"mzmax"}).
\item \code{pData}: accesses the phenotypical description of the samples. Returns a
\code{data.frame}.
\item \verb{pData<-}: replace the phenotype data.
\item \code{phenoData}: accesses the phenotypical description of the samples. Returns
an \code{AnnotatedDataFrame} object.
\item \code{polarity}: returns the polarity of the scans/chromatograms: \code{1}, \code{0} or
\code{-1} for positive, negative or unknown polarity.
\item \code{precursorMz}: return the precursor m/z from the chromatograms. The
method returns a \code{matrix} with 2 columns (\code{"mzmin"} and \code{"mzmax"}) and as
many rows as there are rows in the \code{MChromatograms} object. Each row
contains the precursor m/z of the chromatograms in that row. An error is
thrown if the chromatograms within one row have different precursor m/z
values.
\item \code{productMz}: return the product m/z from the chromatograms. The method
returns a \code{matrix} with 2 columns (\code{"mzmin"} and \code{"mzmax"}) and as many
rows as there are rows in the \code{MChromatograms} object. Each row contains
the product m/z of the chromatograms in that row. An error is thrown if
the chromatograms within one row have different product m/z values.
\item \verb{rownames<-}: replace the rownames (and featureNames) of the object.
}
}

\section{Data subsetting, combining and filtering}{

\itemize{
\item \code{[} subset (similar to a \code{matrix}) by row and column (with parameters \code{i}
and \code{j}).
\item \verb{[<-} replace individual or multiple elements. \code{value} has to be either a
single \code{Chromatogram} obhect or a \code{list} of \code{Chromatogram} objects.
\item \code{c} concatenate (row-wise) \code{MChromatogram} objects with the
\strong{same number of samples (columns)}.
\item \code{filterIntensity}: filter each \code{\link[=Chromatogram]{Chromatogram()}} object within the
\code{MChromatograms} removing data points with intensities below the user
provided threshold. If \code{intensity} is a \code{numeric} value, the returned
chromatogram will only contain data points with intensities > \code{intensity}.
In addition it is possible to provide a function to perform the filtering.
This function is expected to take the input \code{Chromatogram} (\code{object}) and
to return a logical vector with the same length then there are data points
in \code{object} with \code{TRUE} for data points that should be kept and \code{FALSE}
for data points that should be removed. See the \code{filterIntensity}
documentation in the \code{\link[=Chromatogram]{Chromatogram()}} help page for details and examples.
}
}

\section{Data processing and manipulation}{

\itemize{
\item \code{alignRt}: align all chromatograms in an \code{MChromatograms} object against
the chromatogram specified with \code{y}. See documentation on \code{alignRt} in the
\code{\link[=Chromatogram]{Chromatogram()}} help page.
\item \code{bin}: aggregates intensity values of chromatograms in discrete bins
along the retention time axis. By default, individual \code{Chromatogram}
objects of one row are binned into the same bins. The function returns a
\code{MChromatograms} object with binned chromatograms.
\item \code{clean}: removes 0-intensity data points. Either all of them
(with \code{all = TRUE}) or all except those adjacent to non-zero
intensities (\code{all = FALSE}; default). See \code{\link[=clean]{clean()}} documentation for more
details and examples.
\item \code{compareChromatograms}: calculates pairwise similarity score between
chromatograms in \code{x} and \code{y} and returns a similarity matrix with the
number of rows corresponding to the number of chromatograms in \code{x} and
the number of columns to the number of chromatograms in \code{y}.
If \code{y} is missing, a pairwise comparison
is performed between all chromatograms in \code{x}. See documentation on
\code{compareChromatograms} in the \code{\link[=Chromatogram]{Chromatogram()}} help page for details.
\item \code{normalize}, \code{normalise}: \emph{normalises} the intensities of a chromatogram by
dividing them either by the maximum intensity (\code{method = "max"}) or total
intensity (\code{method = "sum"}) of the chromatogram.
\item \code{transformIntensity}: allows to manipulate the intensity values of all
chromatograms using a user provided function. See below for examples.
}
}

\section{Data visualization}{

\itemize{
\item \code{plot}: plots a \code{MChromatograms} object. For each row in the object one
plot is created, i.e. all \code{\link[=Chromatogram]{Chromatogram()}} objects in the same row are
added to the same plot. If \code{nrow(x) > 1} the plot area is split into
\code{nrow(x)} sub-plots and the chromatograms of one row are plotted in
each.
}
}

\examples{
## Creating some chromatogram objects to put them into a MChromatograms object
ints <- abs(rnorm(25, sd = 200))
ch1 <- Chromatogram(rtime = 1:length(ints), ints)
ints <- abs(rnorm(32, sd = 90))
ch2 <- Chromatogram(rtime = 1:length(ints), ints)
ints <- abs(rnorm(19, sd = 120))
ch3 <- Chromatogram(rtime = 1:length(ints), ints)
ints <- abs(rnorm(21, sd = 40))
ch4 <- Chromatogram(rtime = 1:length(ints), ints)

## Create a MChromatograms object with 2 rows and 2 columns
chrs <- MChromatograms(list(ch1, ch2, ch3, ch4), nrow = 2)
chrs

## Extract the first element from the second column. Extracting a single
## element always returns a Chromatogram object.
chrs[1, 2]

## Extract the second row. Extracting a row or column (i.e. multiple elements
## returns by default a list of Chromatogram objects.
chrs[2, ]

## Extract the second row with drop = FALSE, i.e. return a MChromatograms
## object.
chrs[2, , drop = FALSE]

## Replace the first element.
chrs[1, 1] <- ch3
chrs

## Add a pheno data.
pd <- data.frame(name = c("first sample", "second sample"),
    idx = 1:2)
pData(chrs) <- pd

## Column names correspond to the row names of the pheno data
chrs

## Access a column within the pheno data
chrs$name

## Access the m/z ratio for each row; this will be NA for the present
## object
mz(chrs)


## Data visualization

## Create some random Chromatogram objects
ints <- abs(rnorm(123, mean = 200, sd = 32))
ch1 <- Chromatogram(rtime = seq_along(ints), intensity = ints, mz = 231)
ints <- abs(rnorm(122, mean = 250, sd = 43))
ch2 <- Chromatogram(rtime = seq_along(ints), intensity = ints, mz = 231)
ints <- abs(rnorm(125, mean = 590, sd = 120))
ch3 <- Chromatogram(rtime = seq_along(ints), intensity = ints, mz = 542)
ints <- abs(rnorm(124, mean = 1200, sd = 509))
ch4 <- Chromatogram(rtime = seq_along(ints), intensity = ints, mz = 542)

## Combine into a 2x2 MChromatograms object
chrs <- MChromatograms(list(ch1, ch2, ch3, ch4), byrow = TRUE, ncol = 2)

## Plot the second row
plot(chrs[2, , drop = FALSE])

## Plot all chromatograms
plot(chrs, col = c("#ff000080", "#00ff0080"))

## log2 transform intensities
res <- transformIntensity(chrs, log2)
plot(res)
}
\seealso{
\verb{Chromatogram()] for the class representing chromatogram data. [chromatogram()] for the method to extract a }MChromatograms\verb{object from a}MSnExp\code{or}OnDiskMSnExp\verb{ object. [readSRMData()} for the function to read chromatographic data
of an SRM/MRM experiment.
}
\author{
Johannes Rainer
}
