% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aln2dnastring.R
\name{aln2dnastring}
\alias{aln2dnastring}
\title{aln2dnastring}
\usage{
aln2dnastring(aln)
}
\arguments{
\item{aln}{\code{seqinr} \code{alignment} [mandatory]}
}
\value{
An object of class \code{DNAStringSet}
}
\description{
This function converts a \code{seqinr} \code{alignment} into
an \code{DNAStringSet}.
}
\examples{
## define two cds sequences
cds1 <- Biostrings::DNAString("ATGCAACATTGC")
cds2 <- Biostrings::DNAString("ATG---CATTGC")
cds1.cds2.aln <- c(Biostrings::DNAStringSet(cds1),
    Biostrings::DNAStringSet(cds2))
## convert into alignment
#dnastring2aln(cds1.cds2.aln)
cds1.cds2.aln |> dnastring2aln()
## convert back into DNAStringSet
#aln2dnastring(dnastring2aln(cds1.cds2.aln))
cds1.cds2.aln |> dnastring2aln() |> aln2dnastring()
}
\seealso{
\code{\link[seqinr]{as.alignment}}
\code{\link[Biostrings]{DNAStringSet}}
}
\author{
Kristian K Ullrich
}
