% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addpop2string.R
\name{addpop2string}
\alias{addpop2string}
\title{addpop2string}
\usage{
addpop2string(seq, poplist)
}
\arguments{
\item{seq}{\code{DNAStringSet} or \code{AAStringSet} [mandatory]}

\item{poplist}{named \code{list} of populations either as index or names per
population (do not mix index and names in one population) [mandatory]}
}
\value{
An object of class \code{DNAStringSet} or \code{AAStringSet}
}
\description{
This function adds population information to a
\code{DNAStringSet} or an \code{AAStringSet} and puts them into the
\code{metadata} information.\cr
__Note__: All unassigned sequences will be put into pop "unassigned"!\cr
Do not use "unassigned" as a population name!\cr
__Note__: Names in a population in the poplist must match sequence names!\cr
__Note__: Duplicated assignments are allowed!\cr
}
\examples{
## load example sequence data
data(iupac, package="MSA2dist")
iupac.aa <- iupac |> cds2aa(shorten = TRUE)
## create poplist
poplist <- list(FRA = grep("Mmd.FRA", names(iupac)),
    GER = grep("Mmd.GER", names(iupac)),
    IRA = grep("Mmd.IRA", names(iupac)),
    AFG = grep("Mmm.AFG", names(iupac)))
iupac.aa <- iupac.aa |> addpop2string(poplist)
#(iupac.aa |> slot("metadata"))$pop.integer
iupac.aa |> popinteger()
#(iupac.aa |> slot("metadata"))$pop.names
iupac.aa |> popnames()
## mxixing index and names
poplist <- list(FRA = names(iupac)[grep("Mmd.FRA", names(iupac))],
    GER = grep("Mmd.GER", names(iupac)),
    IRA = names(iupac)[grep("Mmd.IRA", names(iupac))],
    AFG = grep("Mmm.AFG", names(iupac)))
iupac.aa <- iupac.aa |> addpop2string(poplist)
iupac.aa |> popinteger()
iupac.aa |> popnames()
## leaving out some sequences which will be assigned as "unassigned"
poplist <- list(FRA = names(iupac)[grep("Mmd.FRA", names(iupac))],
    GER = grep("Mmd.GER", names(iupac)),
    IRA = names(iupac)[grep("Mmd.IRA", names(iupac))])
iupac.aa <- iupac.aa |> addpop2string(poplist)
iupac.aa |> popinteger()
iupac.aa |> popnames()
}
\seealso{
\code{\link[MSA2dist]{addmask2string}},
\code{\link[MSA2dist]{addregion2string}},
\code{\link[MSA2dist]{addpos2string}}
}
\author{
Kristian K Ullrich
}
