% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MOSim.R
\name{plotProfile}
\alias{plotProfile}
\title{Generate a plot of a feature's profile for one or two omics.}
\usage{
plotProfile(simulation, omics, featureIDS, drawReps = FALSE, groups = NULL)
}
\arguments{
\item{simulation}{A MOSimulation object}

\item{omics}{Character vector of the omics to simulate.}

\item{featureIDS}{List containing the feature to show per omic. Must have the
omics as the list names and the features as values.}

\item{drawReps}{Logical to enable/disable the representation of the
replicates inside the plot.}

\item{groups}{Character vector indicating the groups to plot in the form
"GroupX" (i.e. Group1)}
}
\value{
A ggplot2 object.
}
\description{
Generate a plot of a feature's profile for one or two omics.
}
\examples{
omic_list <- c("RNA-seq", "miRNA-seq")

rnaseq_options <- c(omicSim("miRNA-seq", totalFeatures = 2500))
rnaseq_simulation <- mosim(omics = omic_list,
                           omicsOptions = rnaseq_options)

#plotProfile(rnaseq_simulation,
#     omics = c("RNA-seq", "miRNA-seq"),
#   featureIDS = list("RNA-seq"="ENSMUSG00000007682", "miRNA-seq"="mmu-miR-320-3p")
#)

}
