% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MOSim.R
\name{discretize}
\alias{discretize}
\title{Discretize ChIP-Seq counts to simulate a binary dataset}
\usage{
discretize(df, omic)
}
\arguments{
\item{df}{A MOSimulated object}

\item{omic}{Character string of the omic to transform into binary data}
}
\value{
A regulator dataframe of 0 and 1
}
\description{
Discretize ChIP-Seq counts to simulate a binary dataset
}
\examples{
omic_list <- c("RNA-seq", "ChIP-seq")
rnaseq_simulation <- mosim(omics = omic_list, 
    omicsOptions = c(omicSim("ChIP-seq", totalFeatures = 2500)))
rnaseq_simulated <- omicResults(rnaseq_simulation, omic_list)
discrete_ChIP <- discretize(rnaseq_simulated, "ChIP-seq")

}
