% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moma.r
\name{sampleNameFilter}
\alias{sampleNameFilter}
\title{Retain TCGA sample ids without the final letter designation ('A/B/C')}
\usage{
sampleNameFilter(input, desired.len = 15)
}
\arguments{
\item{input}{Matrix of expression or protein activity scores. Columns are 
sample names, rows are genes. Input can also just be an input vector of 
sample names.}

\item{desired.len}{length to reduce strings to. Default is 15 because of 
TCGA naming conventions}
}
\value{
An identical matrix with new (shorter) column names, 
or a vector with the shortened names.
}
\description{
Retain TCGA sample ids without the final letter designation ('A/B/C')
}
\examples{
sample.names <- c("TCGA-14-1825-01A", "TCGA-76-4931-01B", "TCGA-06-5418-01A")
sampleNameFilter(sample.names)
}
