% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlate_covariates.R
\name{summarise_factors}
\alias{summarise_factors}
\title{Summarise factor values using external groups}
\usage{
summarise_factors(
  object,
  df,
  factors = "all",
  groups = "all",
  abs = FALSE,
  return_data = FALSE
)
}
\arguments{
\item{object}{a trained \code{\link{MOFA}} object.}

\item{df}{a data.frame with the columns "sample" and "level", where level is a factor with discrete group assignments for each sample.}

\item{factors}{character vector with the factor name(s), or numeric vector with the index of the factor(s) to use. Default is 'all'.}

\item{groups}{character vector with the groups names, or numeric vector with the indices of the groups of samples to use, or "all" to use samples from all groups.}

\item{abs}{logical indicating whether to take the absolute value of the factors (default is \code{FALSE}).}

\item{return_data}{logical indicating whether to return the fa instead of plotting}
}
\value{
A \code{\link{ggplot}} object or a \code{data.frame} if return_data is TRUE
}
\description{
Function to summarise factor values using a discrete grouping of samples.
}
