% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_factors.R
\name{plot_factors}
\alias{plot_factors}
\title{Scatterplots of two factor values}
\usage{
plot_factors(
  object,
  factors = c(1, 2),
  groups = "all",
  show_missing = TRUE,
  scale = FALSE,
  color_by = NULL,
  shape_by = NULL,
  color_name = NULL,
  shape_name = NULL,
  dot_size = 2,
  alpha = 1,
  legend = TRUE,
  stroke = NULL,
  return_data = FALSE
)
}
\arguments{
\item{object}{a trained \code{\link{MOFA}} object.}

\item{factors}{a vector of length two with the factors to plot. Factors can be specified either as a characters}

\item{groups}{character vector with the groups names, or numeric vector with the indices of the groups of samples to use, or "all" to use samples from all groups.}

\item{show_missing}{logical indicating whether to include samples for which \code{shape_by} or \code{color_by} is missing}

\item{scale}{logical indicating whether to scale factor values.}

\item{color_by}{specifies groups or values used to color the samples. This can be either:
(1) a character giving the name of a feature present in the training data.
(2) a character giving the name of a column present in the sample metadata.
(3) a vector of the same length as the number of samples specifying discrete groups or continuous numeric values.}

\item{shape_by}{specifies groups or values used to shape the samples. This can be either:
(1) a character giving the name of a feature present in the training data, 
(2) a character giving the name of a column present in the sample metadata.
(3) a vector of the same length as the number of samples specifying discrete groups.}

\item{color_name}{name for color legend.}

\item{shape_name}{name for shape legend.}

\item{dot_size}{numeric indicating dot size (default is 2).}

\item{alpha}{numeric indicating dot transparency (default is 1).}

\item{legend}{logical indicating whether to add legend.}

\item{stroke}{numeric indicating the stroke size (the black border around the dots, default is NULL, inferred automatically).}

\item{return_data}{logical indicating whether to return the data frame to plot instead of plotting}
}
\value{
Returns a \code{ggplot2} object
}
\description{
Scatterplot of the values of two latent factors.
}
\details{
One of the first steps for the annotation of factors is to visualise and group/color them using known covariates such as phenotypic or clinical data.
This method generates a single scatterplot for the combination of two latent factors.
TO-FINISH...
\code{\link{plot_factors}} for doing Beeswarm plots for factors.
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)

# Scatterplot of factors 1 and 2
plot_factors(model, factors = c(1,2))

# Shape dots by a column in the metadata
plot_factors(model, factors = c(1,2), shape_by="group")

# Scale factor values from -1 to 1
plot_factors(model, factors = c(1,2), scale = TRUE)

}
