% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_methods.R
\name{get_expectations}
\alias{get_expectations}
\title{Get expectations}
\usage{
get_expectations(object, variable, as.data.frame = FALSE)
}
\arguments{
\item{object}{a trained \code{\link{MOFA}} object.}

\item{variable}{variable name: 'Z' for factors and 'W' for weights.}

\item{as.data.frame}{logical indicating whether to output the result as a long data frame, default is \code{FALSE}.}
}
\value{
the output varies depending on the variable of interest: \cr
\itemize{
 \item{\strong{"Z"}: a matrix with dimensions (samples,factors). If \code{as.data.frame} is \code{TRUE}, a long-formatted data frame with columns (sample,factor,value)}
 \item{\strong{"W"}: a list of length (views) where each element is a matrix with dimensions (features,factors). If \code{as.data.frame} is \code{TRUE}, a long-formatted data frame with columns (view,feature,factor,value)}
}
}
\description{
Function to extract the expectations from the (variational) posterior distributions of a trained \code{\link{MOFA}} object.
}
\details{
Technical note: MOFA is a Bayesian model where each variable has a prior distribution and a posterior distribution. 
In particular, to achieve scalability we used the variational inference framework, thus true posterior distributions are replaced by approximated variational distributions.
This function extracts the expectations of the variational distributions, which can be used as final point estimates to analyse the results of the model. \cr 
The priors and variational distributions of each variable are extensively described in the supplementary methods of the original paper.
}
\examples{
# Using an existing trained model
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)
factors <- get_expectations(model, "Z")
weights <- get_expectations(model, "W")
}
