% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_mofa.R
\name{get_default_stochastic_options}
\alias{get_default_stochastic_options}
\title{Get default stochastic options}
\usage{
get_default_stochastic_options(object)
}
\arguments{
\item{object}{an untrained \code{\link{MOFA}}}
}
\value{
Returns a list with default options
}
\description{
Function to obtain the default options for stochastic variational inference.
}
\details{
This function provides a default set of stochastic inference options that can be modified and passed to the \code{\link{MOFA}} object
in the \code{\link{prepare_mofa}} step), i.e. after creating a \code{\link{MOFA}} object
 (using \code{\link{create_mofa}}) and before starting the training (using \code{\link{run_mofa}})
These options are only relevant when activating stochastic inference in training_options (see example).
The stochastic inference options are the following: \cr
\itemize{
 \item{\strong{batch_size}: numeric value indicating the batch size (as a fraction)}. 
 Default is 0.5 (half of the data set).
 \item{\strong{learning_rate}: numeric value indicating the learning rate. }
 Default is 1.0
 \item{\strong{forgetting_rate}: numeric indicating the forgetting rate.}
 Default is 0.5
 \item{\strong{start_stochastic}: integer indicating the first iteration to start stochastic inference}
 Default is 1
 }
}
\examples{
# Using an existing simulated data with two groups and two views
file <- system.file("extdata", "test_data.RData", package = "MOFA2")

# Load data dt (in data.frame format)
load(file) 

# Create the MOFA object
MOFAmodel <- create_mofa(dt)

# activate stochastic inference in training options
train_opts <- get_default_training_options(MOFAmodel)
train_opts$stochastic <- TRUE

# Load default stochastic options
stochastic_opts <- get_default_stochastic_options(MOFAmodel)

# Edit some of the stochastic options
stochastic_opts$learning_rate <- 0.75
stochastic_opts$batch_size <- 0.25

# Prepare the MOFA object
MOFAmodel <- prepare_mofa(MOFAmodel, 
  training_options = train_opts,
  stochastic_options = stochastic_opts
)

}
