% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlate_covariates.R
\name{correlate_factors_with_covariates}
\alias{correlate_factors_with_covariates}
\title{Plot correlation of factors with external covariates}
\usage{
correlate_factors_with_covariates(
  object,
  covariates,
  factors = "all",
  groups = "all",
  abs = FALSE,
  plot = c("log_pval", "r"),
  alpha = 0.05,
  return_data = FALSE,
  transpose = FALSE,
  ...
)
}
\arguments{
\item{object}{a trained \code{\link{MOFA}} object.}

\item{covariates}{\itemize{
  \item{\strong{data.frame}: a data.frame where the samples are stored in the rows and the covariates are stored in the columns. 
  Use row names for sample names and column names for covariate names. Columns values must be numeric. }
  \item{\strong{character vector}: character vector with names of columns that are present in the sample metadata (\code{samples_metadata(model)}}
}}

\item{factors}{character vector with the factor name(s), or numeric vector with the index of the factor(s) to use. Default is 'all'.}

\item{groups}{character vector with the groups names, or numeric vector with the indices of the groups of samples to use, or "all" to use samples from all groups.}

\item{abs}{logical indicating whether to take the absolute value of the correlation coefficient (default is \code{TRUE}).}

\item{plot}{character indicating whether to plot Pearson correlation coefficients (\code{plot="r"}) or log10 adjusted p-values (\code{plot="log_pval"}).}

\item{alpha}{p-value threshold}

\item{return_data}{logical indicating whether to return the correlation results instead of plotting}

\item{transpose}{logical indicating whether to transpose the plot}

\item{...}{extra arguments passed to \code{\link[corrplot]{corrplot}} (if \code{plot=="r"}) or \code{\link[pheatmap]{pheatmap}} (if \code{plot=="log_pval"}).}
}
\value{
A \code{\link[corrplot]{corrplot}} (if \code{plot=="r"}) or \code{\link[pheatmap]{pheatmap}} (if \code{plot=="log_pval"}) or the underlying data.frame if return_data is TRUE
}
\description{
Function to correlate factor values with external covariates.
}
