% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runPipeline.R
\name{runPipeline}
\alias{runPipeline}
\title{Perform differential methylation analysis}
\usage{
runPipeline(
  set,
  variable_names,
  covariable_names = NULL,
  model = NULL,
  weights = NULL,
  num_vars,
  sva = FALSE,
  betas = TRUE,
  range,
  analyses = c("DiffMean"),
  verbose = FALSE,
  warnings = TRUE,
  DiffMean_params = NULL,
  DiffVar_params = list(coefficient = 1:2),
  rda_params = NULL,
  method = "ls",
  big = FALSE
)
}
\arguments{
\item{set}{\code{GenomicRatioSet}, \code{eSet} derived object or 
\code{SummarizedExperiment}}

\item{variable_names}{Character vector with the names of the variables that
will be returned as result.}

\item{covariable_names}{Character vector with the names of the variables that
will be used to adjust the model.}

\item{model}{Model matrix or formula to get model matrix from \code{set}.}

\item{weights}{weights used in the lmFit model (default NULL)}

\item{num_vars}{Numeric with the number of variables in the matrix for which the
analysis will be performed. Compulsory if equation is not null.}

\item{sva}{Logical. Should Surrogate Variable Analysis be applied? 
(Default: FALSE)}

\item{betas}{If \code{set} is a \code{GenomicRatioSet}, should beta values be
used? (Default: TRUE)}

\item{range}{\code{GenomicRanges} with the region used for RDA}

\item{analyses}{Vector with the names of the analysis to be run (DiffMean and/or DiffVar).}

\item{verbose}{Logical value. If TRUE, it writes out some messages indicating progress. 
If FALSE nothing should be printed.}

\item{warnings}{Should warnings be displayed? (Default:TRUE)}

\item{DiffMean_params}{List with other parameter passed to \code{runBumphunter} 
function.}

\item{DiffVar_params}{List with other parameter passed to \code{runBumphunter} 
function.}

\item{rda_params}{List with other parameter passed to \code{runRDA} 
function.}

\item{method}{String indicating the method used in the regression: "ls" or 
"robust". (Default: "ls")}

\item{big}{Logical value indicating whether SmartSVA should be instead of SVA 
(TRUE recommended for methylation or when having large number of samples). 
Default is FALSE.}
}
\value{
\code{ResultSet} object
}
\description{
Wrapper for analysing differential methylation and expression at region and probe level.
}
\details{
This function is the main wrapper of the package. First, it simplifies the 
the set to only contain the common samples between phenotype and features. In addition,
it allows to change the class of the variables and to apply genomic models (more 
information on \code{preparePhenotype}). Afterwards, analysis per probe and per 
region are done merging the results in an \code{AnalysisResults} object.

Default linear model will contain a sum of the variables and covariables. If 
interactions are desired, a costum formula can be specified. In that case, variables
and covariables must also be specified in order to assure the proper work of the
resulting \code{AnalysisResult}. In addition, the number of variables of the model
for which the calculation will be done \strong{must} be specified.
}
\examples{
if (require(minfiData)){
set <- ratioConvert(mapToGenome(MsetEx[1:10,]))
 res <- runPipeline(set, variable_names = "Sample_Group") 
 res
}
}
