% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runBumphunter.R
\name{runBumphunter}
\alias{runBumphunter}
\title{Run bumphunter}
\usage{
runBumphunter(
  set,
  model,
  coefficient = 2,
  bumphunter_cutoff = 0.1,
  num_permutations = 0,
  bumps_max = 30000,
  betas = TRUE,
  check_perms = FALSE,
  verbose = FALSE,
  resultSet = FALSE,
  ...
)
}
\arguments{
\item{set}{\code{GenomicRatioSet}, \code{eSet} derived object or 
\code{SummarizedExperiment}}

\item{model}{Model matrix or formula to get model matrix from \code{set}.}

\item{coefficient}{Numeric with the column of model matrix used in the analysis.
(Default: 2)}

\item{bumphunter_cutoff}{Numeric with the minimum cutoff to include a probe
in a block. (Default: 0.1)}

\item{num_permutations}{Numeric with the number of permutations run to compute 
the bumps p-value. (Default: 0)}

\item{bumps_max}{Numeric with the maximum number of bumps used in the permutation.
This parameter only applies when \code{num_permutations} is greater than 0. 
(Default: 30000)}

\item{betas}{If \code{set} is a \code{GenomicRatioSet}, should beta values be
used? (Default: TRUE)}

\item{check_perms}{Logical. Should we check that there are less bumps than 
\code{bumps_max}? This parameter only applies when \code{num_permutations} is 
greater than 0. (Default: TRUE)}

\item{verbose}{Logical value. Should the function be verbose? (Default: FALSE)}

\item{resultSet}{Should results be encapsulated in a \code{resultSet}? (Default: TRUE)}

\item{...}{Further arguments passed to \code{bumphunter}.}
}
\value{
data.frame or \code{resultSet} with the result of \code{bumphunter}
}
\description{
Run bumphunter
}
\details{
This function has been deprecated and will be defunct in the new version.
}
\seealso{
\code{\link[minfi]{bumphunter}}
}
