% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResultSet_getGeneVals.R
\name{getGeneVals}
\alias{getGeneVals}
\title{Get all probes related to a gene}
\usage{
getGeneVals(
  object,
  gene,
  rid = 1,
  genecol = "genes",
  fNames = c("chromosome", "start"),
  ...
)
}
\arguments{
\item{object}{\code{ResultSet}}

\item{gene}{Character with the name of the gene}

\item{rid}{Name of the results: "DiffMean" for mean differences, "DiffVar" for
variance differences. (Default: DiffMean)}

\item{genecol}{Character with the column of \code{object} fData with the gene
information}

\item{fNames}{Names of the columns of \code{object} fData that will be added to 
the results data.frame.}

\item{...}{Further arguments passed to \code{getProbeResults}}
}
\value{
data.frame with the results of the analysis of the probes belonging to 
the gene
}
\description{
Given a \code{ResultSet} and a gene name returns the results of the 
analysis of all the probes of the gene.
}
\examples{
\dontrun{
if (require(minfiData)){
 set <- ratioConvert(mapToGenome(MsetEx[1:10,]))
methyOneVar <- runPipeline(set, variable_names = "sex")
getGeneVals(methyOneVar, "TSPY4")
}
}
}
