% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbqnThreshold.R
\name{mbqnGetThreshold}
\alias{mbqnGetThreshold}
\title{Calculates the rank invariance threshold from which on MBQN
should be used instead of 'classical' QN}
\usage{
mbqnGetThreshold(mtx, meanMedian = "mean", plot = TRUE)
}
\arguments{
\item{mtx}{Matrix with samples in columns and features in rows}

\item{meanMedian}{Offset function for the MBQN calculation}

\item{plot}{Boolean values if logistic regression curves that are
used to calculate intersection point should be plotted}
}
\value{
threshold value
}
\description{
Calculates the rank invariance threshold from which on
MBQN should be used instead of 'classical' QN
}
\examples{
set.seed(30)
n <- 20
m <- 20
mtx <- matrix(rnorm(m * n), m, n)
mbqnGetThreshold(mtx)
}
