% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_analyses.R
\name{mbecVarianceStats}
\alias{mbecVarianceStats}
\title{Wrapper for Model Variable Variance Extraction}
\usage{
mbecVarianceStats(model.fit)
}
\arguments{
\item{model.fit}{A linear (mixed) model object of class 'lm' or 'lmerMod'.}
}
\value{
A named row-vector, containing proportional variance for model terms.
}
\description{
For a Linear (Mixed) Model, this function extracts the proportion of variance
that can be explained by terms and interactions and returns a named
row-vector.
}
\details{
Linear Model: Perform an analysis of variance (ANOVA) on the model.fit and
return the Sum of squares for each term, scaled by the total sum of squares.

Linear Mixed Model: employ helper function 'mbecMixedVariance' to extract
residuals, random effects and fixed effects components from the model. The
components are then transformed to reflect explained proportions of variance
for the model coefficients. The function implements transformation for
varying coefficients as well, but NO ADJUSTMENT for single or multiple
coefficients at this point.
}
\examples{
# This will return the data.frame for plotting.
data(dummy.list)
limo <- stats::lm(dummy.list$cnts[,1] ~ group + batch, data=dummy.list$meta)
vec.variance <- mbecVarianceStats(model.fit=limo)
}
\keyword{lm}
\keyword{lmm}
\keyword{proportion}
\keyword{variance}
