% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_reports.R
\name{mbecReportPost}
\alias{mbecReportPost}
\title{Constructs a comparative report of batch corrected data.}
\usage{
mbecReportPost(
  input.obj,
  model.vars = c("batch", "group"),
  type = "clr",
  file.name = NULL,
  file.dir = getwd(),
  return.data = FALSE
)
}
\arguments{
\item{input.obj, }{list of phyloseq objects to compare, first element is
considered uncorrected data}

\item{model.vars, }{required covariates to build models}

\item{type}{One of 'otu', 'tss' or 'clr' to determine the abundance matrix
to use for evaluation.}

\item{file.name}{Optional file name, parameter defaults to NULL and template
name will be used}

\item{file.dir}{Optional output directory, parameter defaults to current
working directory.}

\item{return.data, }{TRUE will return a list of all produced plots, FALSE will
start rendering the report}
}
\value{
either a ggplot2 object or a formatted data-frame to plot from
}
\description{
Constructs a comparative report of batch corrected data.
}
\examples{
data(dummy.list)
dummy.test <- mbecTransform(list(dummy.list$cnts[,seq(20)],
dummy.list$meta), method="clr")
dummy.corrected <- mbecCorrection(input.obj=dummy.test,
model.vars=c("batch","group"), method="bat", type="clr" )

report.data <- mbecReportPost(input.obj=dummy.corrected,
model.vars=c("batch","group"), type="clr", file.name=NULL, file.dir=NULL,
return.data = TRUE)
}
