% Generated by roxygen2 (4.0.1): do not edit by hand
\name{getPFinal}
\alias{getPFinal}
\title{Function that adjusts true underlying allele frequency for pre-existing allelic bias to produce actual generating probability of observing allele-supporting read}
\usage{
getPFinal(trueAF, noASEAF, checkArgs = FALSE)
}
\arguments{
\item{trueAF}{true underlying allele frequency. Must be a single number >=0 and <=1.}

\item{noASEAF}{probability of observing allele-supporting read under conditions of no ASE. Must be a vector of numbers >0 and <1.}

\item{checkArgs}{single boolean specifying whether arguments should be checked for adherence to specifications. DEFAULT: FALSE}
}
\value{
a vector of generating probabilities of the same length as noASEAF
}
\description{
Function that adjusts true underlying allele frequency for pre-existing allelic bias to produce actual generating probability of observing allele-supporting read
}
\details{
Given true underlying allele frequency AF and probability of observing reads supporting that allele under conditiosn of no ASE (P(allele, noASE)), it calculates the generating probability for observed allele-supporting reads as P(allele-supporting read)=AF*P(allele, noASE)/(AF*P(allele, noASE) + (1-AF)*(1-P(allele, noASE))).
}
\examples{
MBASED:::getPFinal(trueAF=1, noASEAF=seq(0.1, 0.9, by=0.1)) ## is always 1
MBASED:::getPFinal(trueAF=0, noASEAF=seq(0.1, 0.9, by=0.1)) ## is always 0
MBASED:::getPFinal(trueAF=0.3, noASEAF=0.5) ## no pre-existing allelic bias
c(MBASED:::getPFinal(trueAF=0.3, noASEAF=0.9), MBASED:::getPFinal(trueAF=1-0.3, noASEAF=1-0.9)) ## strong pre-existing allelic bias
}

