% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdgbroadcall.R
\name{bdgbroadcall}
\alias{bdgbroadcall}
\title{bdgbroadcall}
\usage{
bdgbroadcall(
  ifile,
  cutoffpeak = 2,
  cutofflink = 1,
  minlen = 200L,
  lvl1maxgap = 30L,
  lvl2maxgap = 800L,
  trackline = TRUE,
  outdir = ".",
  outputfile = character(),
  oprefix = character(),
  log = TRUE,
  verbose = 2L
)
}
\arguments{
\item{ifile}{MACS score in bedGraph. REQUIRED.}

\item{cutoffpeak}{Cutoff for peaks depending on which method you used for score track. If the file contains qvalue scores from MACS3, score 2 means qvalue 0.01. Regions with signals lower than cutoff will not be considerred as enriched regions. DEFAULT: 2}

\item{cutofflink}{Cutoff for linking regions/low abundance regions depending on which method you used for score track. If the file contains qvalue scores from MACS3, score 1 means qvalue 0.1, and score 0.3 means qvalue 0.5. DEFAULT: 1}

\item{minlen}{minimum length of peak, better to set it as d value. DEFAULT: 200",
default = 200}

\item{lvl1maxgap}{maximum gap between significant peaks, better to
set it as tag size. DEFAULT: 30}

\item{lvl2maxgap}{maximum linking between significant peaks, better
to set it as 4 times of d value. DEFAULT: 800}

\item{trackline}{Tells MACS not to include trackline with bedGraph
files. The trackline is required by UCSC.}

\item{outdir}{The output directory.}

\item{outputfile}{Output file name. Mutually exclusive with --o-prefix}

\item{oprefix}{The PREFIX of output bedGraph file to write
scores. If it is given as A, and method is 'ppois', output file
will be A_ppois.bdg. Mutually exclusive with -o/--ofile.}

\item{log}{Whether to capture logs.}

\item{verbose}{Set verbose level of runtime message. 0: only show
critical message, 1: show additional warning message, 2: show
process information, 3: show debug messages. DEFAULT:2}
}
\value{
\code{macsList} object.
}
\description{
Call broad peaks from bedGraph output. Note: All regions on the
same chromosome in the bedGraph file should be continuous so only
bedGraph files from MACS3 are accpetable.
}
\examples{
eh <- ExperimentHub::ExperimentHub()
CHIP <- eh[["EH4558"]]
CTRL <- eh[["EH4563"]]
p1 <- pileup(CHIP, outdir = tempdir(),
             outputfile = "pileup_ChIP_bed.bdg", format = "BED")
p2 <- pileup(CTRL, outdir = tempdir(),
             outputfile = "pileup_CTRL_bed.bdg", format = "BED")
c1 <- bdgcmp(p1$outputs, p2$outputs, outdir = tempdir(),
             oprefix = "bdgcmp", pseudocount = 1, method = "FE")
bdgbroadcall(c1$outputs, cutoffpeak = 2, cutofflink = 1.5,
             outdir = tempdir(), outputfile = "bdgbroadcall")
}
