% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustersim.R
\name{clustersim}
\alias{clustersim}
\title{clustersim: A cluster simulator for testing clustering algorithms}
\usage{
clustersim(n, n2, r, K, alpha, wobble, redp = NULL, print = FALSE,
  seed = NULL)
}
\arguments{
\item{n}{Numerical value: The number of samples, it must be square rootable}

\item{n2}{Numerical value: The number of features}

\item{r}{Numerical value: The radius to define the initial circle (use approx n/100)}

\item{K}{Numerical value: How many clusters to simulate}

\item{alpha}{Numerical value: How far to pull apart the clusters}

\item{wobble}{Numerical value: The degree of noise to add to the sample co ordinates}

\item{redp}{Numerical value: The fraction of samples to remove from one cluster}

\item{print}{Logical flag: whether to print the PCA into current directory}

\item{seed}{Numerical value: fixes the seed if you want to repeat results}
}
\value{
A list: containing 1) matrix with simulated data in it
}
\description{
clustersim: A cluster simulator for testing clustering algorithms
}
\examples{
res <- clustersim(225, 900, 8, 4, 0.75, 0.025, redp = NULL, seed=123)
}
