% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchPublished.R
\name{searchPublished}
\alias{searchPublished}
\title{Search for T cell receptor beta CDR3 amino acid sequences with known antigen 
specificity}
\usage{
searchPublished(list)
}
\arguments{
\item{list}{A list of data frames generated by the LymphoSeq functions 
readImmunoSeq or productiveSeq.  "aminoAcid", "frequencyCount", and "count" 
are required columns.}
}
\value{
Returns a data frame of each sample name and instance in the sample 
that the published TCR sequence appeared along with additional 
information including antigen specificity, epitope, HLA type, and PubMed ID 
(PMID) for the reference where the sequence was characterized.  The 
publishedTRB database is located in a separate package called LymphoSeqDB 
that should be loaded automatically.
}
\description{
Search for published T cell receptor beta CDR3 amino acid sequences with 
known antigen specificity in a list of data frames.
}
\examples{
file.path <- system.file("extdata", "TCRB_sequencing", package = "LymphoSeq")

file.list <- readImmunoSeq(path = file.path)

productive.aa <- productiveSeq(file.list = file.list, aggregate = "aminoAcid")

searchPublished(list = productive.aa)
}
\seealso{
Refer to the LymphoSeqDB package for details regarding the 
publishedTRB database.
}
