% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commonSeqs.R
\name{commonSeqs}
\alias{commonSeqs}
\title{Common sequences in two or more samples}
\usage{
commonSeqs(samples, productive.aa)
}
\arguments{
\item{samples}{A character vector of two or more sample names in 
productive.aa.}

\item{productive.aa}{A list of productive amino acid sequences generated
by the LymphoSeq function productiveSeq where aggregate = "aminoAcid".}
}
\value{
Returns a data frame of the common sequences between two or more files 
displaying their frequencies in each.
}
\description{
Creates a data frame of the common sequences in two or more samples, reporting 
their frequencies in each.
}
\examples{
file.path <- system.file("extdata", "TCRB_sequencing", package = "LymphoSeq")

file.list <- readImmunoSeq(path = file.path)

productive.aa <- productiveSeq(file.list = file.list, aggregate = "aminoAcid")

commonSeqs(samples = c("TRB_Unsorted_0", "TRB_Unsorted_32"), 
   productive.aa = productive.aa)
}
\seealso{
\code{\link{commonSeqsVenn}}
}
