% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotVAF.R
\name{plotVAFdistr}
\alias{plotVAFdistr}
\title{Plot histogram of VAF distribution}
\usage{
plotVAFdistr(
  vaf = NULL,
  vaf.interval = 0.05,
  t_sample = NULL,
  vaf.show.counts = FALSE,
  vaf.show.density = TRUE,
  vaf.col = "#34495e",
  vaf.border = "#bdc3c7",
  srtcounts = 45,
  output.file = NULL,
  ...
)
}
\arguments{
\item{vaf}{output produced by \code{\link{readVCF}}}

\item{vaf.interval}{Interval size. Default 0.05}

\item{t_sample}{Sample name for tumor. Used for plot title. Default NULL}

\item{vaf.show.counts}{Show counter per break on the histogram. Default FALSE}

\item{vaf.show.density}{Show additional inset plot of density. Default TRUE}

\item{vaf.col}{Color to be used to fill the bars, default "#34495e"}

\item{vaf.border}{Border color, default "#bdc3c7"}

\item{srtcounts}{Text angle if \code{vaf.show.counts} is TRUE. Default 45}

\item{output.file}{Optional, will save the plot.}

\item{...}{further arguments and parameters passed to other
LACHESIS functions.}
}
\value{
VAF histogram
}
\description{
Plot frequency distribution of variant allele frequencies
}
\examples{
strelka_vcf <- system.file("extdata", "strelka2.somatic.snvs.vcf.gz",
    package = "LACHESIS"
)
s_data <- readVCF(
    vcf = strelka_vcf, vcf.source = "strelka",
    ignore.XY = FALSE
)
plotVAFdistr(s_data)
}
