% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbImport.R
\name{plotNB}
\alias{plotNB}
\title{Plot VAF distribution per copy number}
\usage{
plotNB(
  nb = NULL,
  snvClonality = NULL,
  ref.build = "hg19",
  min.cn = 2,
  max.cn = 4,
  nb.col.abline = "gray70",
  nb.col.cn.2 = "#7f8c8d",
  nb.col.cn = "#16a085",
  nb.col.hist = "#34495e",
  nb.border = NA,
  nb.breaks = 100,
  samp.name = NULL,
  output.file = NULL,
  sig.show = FALSE,
  ...
)
}
\arguments{
\item{nb}{output generated from \code{\link{nbImport}}.}

\item{snvClonality}{output generated from \code{\link{estimateClonality}}.}

\item{ref.build}{Reference genome. Default \code{hg19}.
Can be \code{hg18}, \code{hg19} or \code{hg38}.}

\item{min.cn}{maximum copy number to be included in the plotting.
Defaults to 2.}

\item{max.cn}{maximum copy number to be included in the plotting.
Defaults to 4.}

\item{nb.col.abline}{optional, the color code for the lines depicting
clonality in the VAF histograms.}

\item{nb.col.cn.2}{optional, the color code for tcn = 2 in the CNV plot.}

\item{nb.col.cn}{optional, the color code for other copy numbers in the
CNV plot.}

\item{nb.col.hist}{optional, the color code for bars in the VAF histograms.}

\item{nb.border, }{optional, the line color in the VAF histograms.}

\item{nb.breaks}{optional, the number of bins in the histograms.}

\item{samp.name}{Sample name. Optional. Default NULL}

\item{output.file}{optional, will save the plot.}

\item{sig.show}{plot stratified VAF histogram with assigned
mutational signatures.}

\item{...}{further arguments and parameters passed to other LACHESIS
functions.}
}
\value{
copy number plot, VAF histograms stratified by copynumber and
clonality; if specified, VAF histograms stratified by copynumber and
signature
}
\description{
Visualizes results from  \code{\link{nbImport}}. Top plot, measured copy
numbers along the genome; bottom plots, VAF histograms of SNVs stratified
by copy number and minor/major allele count.
}
\examples{
# Example using all variants from vcf file
snvs <- system.file("extdata", "NBE15",
    "snvs_NBE15_somatic_snvs_conf_8_to_10.vcf",
    package = "LACHESIS"
)
s_data <- readVCF(vcf = snvs, vcf.source = "dkfz")
aceseq_cn <- system.file("extdata", "NBE15",
    "NBE15_comb_pro_extra2.51_1.txt",
    package = "LACHESIS"
)
c_data <- readCNV(aceseq_cn)
nb <- nbImport(cnv = c_data, snv = s_data, purity = 1, ploidy = 2.51)
cl_muts <- clonalMutationCounter(nb)
norm_muts <- normalizeCounts(cl_muts)
mrca <- MRCA(norm_muts)
snvClonality <- estimateClonality(
    nbObj = nb, mrcaObj = mrca, ID = "NBE15",
    purity = 1
)
plotNB(nb = nb, snvClonality = snvClonality)

# Example using variants associated with specific SBS mutational
# signatures from vcf file
snvs <- system.file("extdata", "NBE15",
    "snvs_NBE15_somatic_snvs_conf_8_to_10.vcf",
    package = "LACHESIS"
)
s_data <- readVCF(vcf = snvs, vcf.source = "dkfz")
aceseq_cn <- system.file("extdata", "NBE15",
    "NBE15_comb_pro_extra2.51_1.txt",
    package = "LACHESIS"
)
c_data <- readCNV(aceseq_cn)
sig.filepath <- system.file("extdata",
    "NBE15_Decomposed_MutationType_Probabilities.txt",
    package = "LACHESIS"
)
nb <- nbImport(
    cnv = c_data, snv = s_data, purity = 1, ploidy = 2.51,
    sig.assign = TRUE, ID = "NBE15", sig.file = sig.filepath
)
cl_muts <- clonalMutationCounter(nb)
norm_muts <- normalizeCounts(cl_muts)
mrca <- MRCA(norm_muts)
snvClonality <- estimateClonality(
    nbObj = nb, mrcaObj = mrca, ID = "NBE15",
    purity = 1
)
plotNB(nb = nb, snvClonality = snvClonality, sig.show = TRUE)

}
