% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LACHESIS.R
\name{plotLachesis}
\alias{plotLachesis}
\title{Plot SNV densities at ECA and MRCA}
\usage{
plotLachesis(
  lachesis = NULL,
  lach.suppress.outliers = FALSE,
  lach.log.densities = FALSE,
  lach.col.multi = "#176A02",
  lach.border = NULL,
  binwidth = NULL,
  lach.col.zero = "#4FB12B",
  output.file = NULL,
  ...
)
}
\arguments{
\item{lachesis}{output generated from \code{\link{LACHESIS}}}

\item{lach.suppress.outliers}{whether outliers (defined as the 2.5\% tumors
with lowest and highest densities) are to be plot. Default \code{TRUE}.}

\item{lach.log.densities}{plot logarithmic densities. Default \code{FALSE}.}

\item{lach.col.multi}{optional, bar color for multi-copy SSNV densities.}

\item{lach.border, }{optional, border color for the bars.}

\item{binwidth}{optional, the binwidth in the histogram.}

\item{lach.col.zero}{optional, bar color for single-copy SSNV densities.}

\item{output.file}{optional, the file to which the plot will be stored.}

\item{...}{further arguments and parameters passed to other LACHESIS
functions.}
}
\value{
graph with cohort overview of SNV densities at ECA/ MRCA
}
\description{
Visualizes results from \code{\link{LACHESIS}}. Top plot, histograms of mean
mutation densities; bottom plots, cumulative distribution of mean mutation
densities with 95\% confidence intervals.
}
\examples{
# An example file with sample annotations and meta data
input.files <- system.file("extdata", "Sample_template.txt",
    package = "LACHESIS"
)
input.files <- data.table::fread(input.files)

# cnv and snv files for example tumors
nbe11 <- list.files(system.file("extdata/NBE11/", package = "LACHESIS"),
    full.names = TRUE
)
nbe15 <- list.files(system.file("extdata/NBE15/", package = "LACHESIS"),
    full.names = TRUE
)
nbe26 <- list.files(system.file("extdata/NBE26/", package = "LACHESIS"),
    full.names = TRUE
)

cnv.file <- c(nbe11[1], nbe15[1], nbe26[1])
snv.file <- c(nbe11[2], nbe15[2], nbe26[2])

input.files$cnv.file <- cnv.file
input.files$snv.file <- snv.file

# Make an example input file with paths to cnv and snv file along with other
# meta data
lachesis_input <- tempfile(
    pattern = "lachesis", tmpdir = tempdir(),
    fileext = ".tsv"
)
data.table::fwrite(x = input.files, file = lachesis_input, sep = "\t")

# Example with template file with paths to multiple cnv/snv files as an input
lachesis <- LACHESIS(input.files = lachesis_input)
plotLachesis(lachesis)
}
